/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ocsp;

import eu.emi.security.authn.x509.helpers.ocsp.BoundedSizeLruMap;
import eu.emi.security.authn.x509.helpers.ocsp.OCSPCacheBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class OCSPRespondersCache
extends OCSPCacheBase {
    private Map<String, ResponderCacheEntry> respondersCache = Collections.synchronizedMap(new BoundedSizeLruMap(100));

    public OCSPRespondersCache(long maxTtl, File diskPath, String prefix) {
        super(maxTtl == 0L ? 3600L : maxTtl, diskPath, prefix);
    }

    public void checkCachedError(String responderKey) throws IOException {
        File f;
        ResponderCacheEntry cachedError = this.respondersCache.get(responderKey);
        if (cachedError == null && this.diskPath != null && (f = new File(this.diskPath, this.prefix + responderKey)).exists()) {
            cachedError = this.loadResponderFromDisk(f);
        }
        if (cachedError == null) {
            return;
        }
        Date now = new Date();
        if (now.after(cachedError.maxValidity)) {
            this.respondersCache.remove(responderKey);
            if (this.diskPath != null) {
                File f2 = new File(this.diskPath, this.prefix + responderKey);
                f2.delete();
            }
            return;
        }
        if (cachedError.error != null) {
            throw cachedError.error;
        }
    }

    public void addToCache(String key, IOException error) throws IOException {
        Date maxCacheValidity = new Date(System.currentTimeMillis() + this.maxTtl);
        ResponderCacheEntry entry = new ResponderCacheEntry(maxCacheValidity, error);
        this.respondersCache.put(key, entry);
        if (this.diskPath != null) {
            File f = new File(this.diskPath, this.prefix + key);
            this.storeResponderToDisk(f, entry);
        }
    }

    public void clearMemoryCache() {
        this.respondersCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeResponderToDisk(File f, ResponderCacheEntry entry) throws IOException {
        if (f.exists()) {
            f.delete();
        }
        ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(f));
        try {
            oos.writeObject(entry.maxValidity);
            oos.writeObject(entry.error);
        }
        finally {
            oos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponderCacheEntry loadResponderFromDisk(File f) {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(f));
            Date maxCache = (Date)ois.readObject();
            IOException error = (IOException)ois.readObject();
            ResponderCacheEntry responderCacheEntry = new ResponderCacheEntry(maxCache, error);
            return responderCacheEntry;
        }
        catch (Exception e) {
            f.delete();
            ResponderCacheEntry responderCacheEntry = null;
            return responderCacheEntry;
        }
        finally {
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public String createResponderKey(X509Certificate issuerCert) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("JDK problem: SHA-1 hash not supported by any provider!", e);
        }
        PublicKey issuerKey = issuerCert.getPublicKey();
        digest.update(issuerCert.getSubjectX500Principal().getEncoded());
        digest.update(issuerKey.getEncoded());
        return this.encodeDigest(digest);
    }

    private static class ResponderCacheEntry {
        private Date maxValidity;
        private IOException error;

        public ResponderCacheEntry(Date maxValidity, IOException error) {
            this.maxValidity = maxValidity;
            this.error = error;
        }
    }
}

