/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.dcache.xrootd.plugins.authn.gsi.DHSession;
import org.dcache.xrootd.security.BufferDecrypter;
import org.dcache.xrootd.security.BufferEncrypter;

public class DHBufferHandler
implements BufferEncrypter,
BufferDecrypter {
    private DHSession session;
    private String cipherSpec;
    private String keySpec;
    private int blocksize;

    public DHBufferHandler(DHSession session, String cipherSpec, String keySpec, int blocksize) {
        this.session = session;
        this.cipherSpec = cipherSpec;
        this.keySpec = keySpec;
        this.blocksize = blocksize;
    }

    public byte[] decrypt(byte[] encrypted) throws InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException {
        byte[] full = this.session.decrypt(this.cipherSpec, this.keySpec, this.blocksize, encrypted);
        if (full.length > 32) {
            return Arrays.copyOf(full, 32);
        }
        return full;
    }

    public byte[] encrypt(byte[] unencrypted) throws InvalidKeyException, IllegalStateException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, NoSuchProviderException {
        int origLen = unencrypted.length;
        unencrypted = Arrays.copyOf(unencrypted, origLen + 16);
        for (int i = 0; i < 16; ++i) {
            unencrypted[origLen + i] = 16;
        }
        return this.session.encrypt(this.cipherSpec, this.keySpec, this.blocksize, unencrypted);
    }
}

