/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.impl;

import java.io.Serializable;
import java.security.cert.CertStoreParameters;
import java.util.ArrayList;
import java.util.List;

public class CRLParameters
implements CertStoreParameters,
Serializable {
    private static final long serialVersionUID = 1L;
    private List<String> crls;
    private long crlUpdateInterval;
    private int remoteConnectionTimeout;
    private String diskCachePath;

    public CRLParameters(List<String> crls, long crlUpdateInterval, int remoteConnectionTimeout, String diskCachePath) {
        if (crls == null) {
            throw new IllegalArgumentException("CRLs list may not be null");
        }
        if (remoteConnectionTimeout < 0) {
            throw new IllegalArgumentException("Remote connection timeout must be a non negative number");
        }
        this.crls = crls;
        this.crlUpdateInterval = crlUpdateInterval;
        this.remoteConnectionTimeout = remoteConnectionTimeout;
        this.diskCachePath = diskCachePath;
    }

    public CRLParameters() {
        this(new ArrayList<String>(0), -1L, 5000, null);
    }

    @Override
    public CRLParameters clone() {
        ArrayList<String> copy = new ArrayList<String>();
        copy.addAll(this.crls);
        return new CRLParameters(copy, this.crlUpdateInterval, this.remoteConnectionTimeout, this.diskCachePath);
    }

    public String getDiskCachePath() {
        return this.diskCachePath;
    }

    public void setDiskCachePath(String diskCachePath) {
        this.diskCachePath = diskCachePath;
    }

    public int getRemoteConnectionTimeout() {
        return this.remoteConnectionTimeout;
    }

    public void setRemoteConnectionTimeout(int remoteConnectionTimeout) {
        this.remoteConnectionTimeout = remoteConnectionTimeout;
    }

    public List<String> getCrls() {
        return this.crls;
    }

    public void setCrls(List<String> crls) {
        this.crls = crls;
    }

    public long getCrlUpdateInterval() {
        return this.crlUpdateInterval;
    }

    public void setCrlUpdateInterval(long crlUpdateInterval) {
        this.crlUpdateInterval = crlUpdateInterval;
    }
}

