/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucket;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucketUtils;
import org.dcache.xrootd.security.XrootdSecurityProtocol;

public class UnsignedIntBucket
extends GSIBucket {
    private final int _data;

    public UnsignedIntBucket(XrootdSecurityProtocol.BucketType type, int data) {
        super(type);
        this._data = data;
    }

    @Override
    public int dump(StringBuilder builder, String step, int number) {
        super.dump(builder, step, number);
        builder.append("//\n");
        builder.append("//                UNSIGNED INT CONTENTS\n");
        builder.append("//\n");
        builder.append("//  decimal: ").append(this._data).append("\n");
        builder.append("//\n");
        ByteBuffer b = ByteBuffer.allocate(4);
        b.putInt(this._data);
        byte[] result = b.array();
        GSIBucketUtils.dumpBytes(builder, result);
        return number;
    }

    public int getContent() {
        return this._data;
    }

    public static UnsignedIntBucket deserialize(XrootdSecurityProtocol.BucketType type, ByteBuf buffer) {
        return new UnsignedIntBucket(type, buffer.getInt(0));
    }

    @Override
    public void serialize(ByteBuf out) {
        super.serialize(out);
        out.writeInt(4);
        out.writeInt(this._data);
    }

    @Override
    public int getSize() {
        return super.getSize() + 8;
    }

    @Override
    public String toString() {
        return super.toString() + " decimal int: " + this._data;
    }
}

