/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi.pre49;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Optional;
import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucket;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucketUtils;
import org.dcache.xrootd.plugins.authn.gsi.GSICredentialManager;
import org.dcache.xrootd.plugins.authn.gsi.GSIServerRequestHandler;
import org.dcache.xrootd.plugins.authn.gsi.NestedBucketBuffer;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.OkResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;
import org.dcache.xrootd.security.XrootdSecurityProtocol;

public class GSIPre49ServerRequestHandler
extends GSIServerRequestHandler {
    public GSIPre49ServerRequestHandler(Subject subject, GSICredentialManager credentialManager) throws XrootdException {
        super(subject, credentialManager);
    }

    @Override
    public int getProtocolVersion() {
        return 10300;
    }

    @Override
    public XrootdResponse<AuthenticationRequest> handleCertReqStep(AuthenticationRequest request, GSIBucketUtils.BucketData data) throws XrootdException {
        return this.handleCertReqStep(request, data, false, XrootdSecurityProtocol.BucketType.kXRS_puk);
    }

    @Override
    public XrootdResponse<AuthenticationRequest> handleCertStep(AuthenticationRequest request, GSIBucketUtils.BucketData data) throws XrootdException {
        try {
            Map<XrootdSecurityProtocol.BucketType, GSIBucket> receivedBuckets = data.getBucketMap();
            this.validateCiphers(receivedBuckets);
            this.validateDigests(receivedBuckets);
            this.finalizeSessionKey(receivedBuckets, XrootdSecurityProtocol.BucketType.kXRS_puk);
            NestedBucketBuffer mainBucket = this.decryptMainBucketWithSessionKey(receivedBuckets, "kXGC_cert");
            X509Certificate[] certChain = this.processRSAVerification(mainBucket.getNestedBuckets(), Optional.empty());
            this.subject.getPublicCredentials().add(certChain);
            this.rsaSession.initializeForDecryption(certChain[0].getPublicKey());
            this.verifySignedRTag(mainBucket.getNestedBuckets());
            return new OkResponse((XrootdRequest)request);
        }
        catch (InvalidKeyException ikex) {
            LOGGER.error("The key negotiated by DH key exchange appears to be invalid: {}", (Object)ikex.getMessage());
            throw new XrootdException(3023, "Could not decrypt clientinformation with negotiated key.");
        }
        catch (IOException ioex) {
            LOGGER.error("Could not deserialize main nested buffer {}", (Object)(ioex.getMessage() == null ? ioex.getClass().getName() : ioex.getMessage()));
            throw new XrootdException(10007, "Could not decrypt encrypted client message.");
        }
        catch (GeneralSecurityException gssex) {
            LOGGER.error("Error during decrypting/server-side key exchange: {}", (Object)gssex.getMessage());
            throw new XrootdException(3023, "Error in server-side cryptographic operations.");
        }
    }

    @Override
    public XrootdResponse<AuthenticationRequest> handleSigPxyStep(AuthenticationRequest request, GSIBucketUtils.BucketData data) throws XrootdException {
        throw new XrootdException(10026, "proxy request signing step not supported.");
    }

    @Override
    public boolean isFinished(GSIBucketUtils.BucketData data) {
        return 1001 == data.getStep();
    }

    @Override
    protected String getSyncCipherMode() {
        return "AES/CBC/PKCS5Padding";
    }
}

