/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers;

import eu.emi.security.authn.x509.X509Credential;
import eu.emi.security.authn.x509.helpers.ssl.CredentialX509KeyManager;
import eu.emi.security.authn.x509.impl.CertificateUtils;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.X509ExtendedKeyManager;

public abstract class AbstractX509Credential
implements X509Credential {
    public static final String ALIAS = "defaultKey";
    public static final char[] KEY_PASSWD;
    protected KeyStore ks;

    @Override
    public KeyStore getKeyStore() {
        return this.ks;
    }

    @Override
    public X509ExtendedKeyManager getKeyManager() {
        return new CredentialX509KeyManager(this);
    }

    @Override
    public char[] getKeyPassword() {
        return KEY_PASSWD;
    }

    @Override
    public String getKeyAlias() {
        return ALIAS;
    }

    @Override
    public PrivateKey getKey() {
        try {
            return (PrivateKey)this.ks.getKey(this.getKeyAlias(), this.getKeyPassword());
        }
        catch (Exception e) {
            throw new RuntimeException("Shouldn't happen: can't retrieve key from credential's keystore", e);
        }
    }

    @Override
    public X509Certificate getCertificate() {
        try {
            return (X509Certificate)this.ks.getCertificate(this.getKeyAlias());
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Shouldn't happen: can't retrieve certificate from credential's keystore", e);
        }
    }

    @Override
    public X509Certificate[] getCertificateChain() {
        try {
            return CertificateUtils.convertToX509Chain(this.ks.getCertificateChain(this.getKeyAlias()));
        }
        catch (KeyStoreException e) {
            throw new RuntimeException("Shouldn't happen: can't retrieve certificates from credential's keystore", e);
        }
    }

    @Override
    public String getSubjectName() {
        return this.getCertificate().getSubjectX500Principal().getName();
    }

    static {
        CertificateUtils.configureSecProvider();
        KEY_PASSWD = "key!password".toCharArray();
    }
}

