/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ocsp;

import java.io.File;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import org.bouncycastle.util.encoders.Base64;

public abstract class OCSPCacheBase {
    protected static final Charset ASCII = Charset.forName("US-ASCII");
    protected final long maxTtl;
    protected final File diskPath;
    protected final String prefix;

    public OCSPCacheBase(long maxTtl, File diskPath, String prefix) {
        this.maxTtl = maxTtl;
        this.diskPath = diskPath;
        this.prefix = prefix == null ? "" : prefix;
    }

    protected String encodeDigest(MessageDigest digest) {
        byte[] shortBytes = digest.digest();
        byte[] ascii = Base64.encode((byte[])shortBytes);
        String ret = new String(ascii, ASCII);
        return ret.replace('/', '_');
    }
}

