/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.gsi.post49;

import eu.emi.security.authn.x509.impl.PEMCredential;
import java.io.IOException;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.authn.gsi.CertUtil;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucket;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucketContainer;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucketContainerBuilder;
import org.dcache.xrootd.plugins.authn.gsi.GSIBucketUtils;
import org.dcache.xrootd.plugins.authn.gsi.GSICredentialManager;
import org.dcache.xrootd.plugins.authn.gsi.GSIServerRequestHandler;
import org.dcache.xrootd.plugins.authn.gsi.NestedBucketBuffer;
import org.dcache.xrootd.plugins.authn.gsi.StringBucket;
import org.dcache.xrootd.plugins.authn.gsi.UnsignedIntBucket;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.AuthenticationResponse;
import org.dcache.xrootd.protocol.messages.OkResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;
import org.dcache.xrootd.security.XrootdSecurityProtocol;

public class GSIPost49ServerRequestHandler
extends GSIServerRequestHandler {
    private boolean hasProxy;
    private boolean clientCanSignRequest;

    public GSIPost49ServerRequestHandler(Subject subject, GSICredentialManager credentialManager) throws XrootdException {
        super(subject, credentialManager);
    }

    @Override
    public int getProtocolVersion() {
        return 10400;
    }

    @Override
    public XrootdResponse<AuthenticationRequest> handleCertReqStep(AuthenticationRequest request, GSIBucketUtils.BucketData data) throws XrootdException {
        UnsignedIntBucket clientOpts = (UnsignedIntBucket)data.getBucketMap().get(XrootdSecurityProtocol.BucketType.kXRS_clnt_opts);
        if (clientOpts != null) {
            this.clientCanSignRequest = Integer.lowestOneBit(clientOpts.getContent() >> 2) == 1;
            LOGGER.debug("Received kXRS_clnt_opts {}; can sign proxy requests {}.", (Object)clientOpts.getContent(), (Object)this.clientCanSignRequest);
        }
        return this.handleCertReqStep(request, data, true, XrootdSecurityProtocol.BucketType.kXRS_cipher);
    }

    @Override
    public XrootdResponse<AuthenticationRequest> handleCertStep(AuthenticationRequest request, GSIBucketUtils.BucketData data) throws XrootdException {
        try {
            this.dhSession.setPaddedKey(true);
            Map<XrootdSecurityProtocol.BucketType, GSIBucket> receivedBuckets = data.getBucketMap();
            this.dhSession.setSessionIVLen(GSIPost49ServerRequestHandler.findSessionIVLen(this.validateCiphers(receivedBuckets)));
            this.validateDigests(receivedBuckets);
            PublicKey clientPuk = this.extractClientPublicKey(receivedBuckets);
            this.rsaSession.initializeForDecryption(clientPuk);
            this.finalizeSessionKey(receivedBuckets, XrootdSecurityProtocol.BucketType.kXRS_cipher);
            NestedBucketBuffer mainBucket = this.decryptMainBucketWithSessionKey(receivedBuckets, "kXGC_cert");
            X509Certificate[] certChain = this.processRSAVerification(mainBucket.getNestedBuckets(), Optional.of(clientPuk));
            this.subject.getPublicCredentials().add(certChain);
            this.verifySignedRTag(mainBucket.getNestedBuckets());
            if (this.clientCanSignRequest) {
                return this.getSigPxyResponse(certChain, request, mainBucket);
            }
            this.hasProxy = true;
            return new OkResponse((XrootdRequest)request);
        }
        catch (InvalidKeyException ikex) {
            this.cancelHandshake();
            LOGGER.error("The key negotiated by DH key exchange appears to be invalid: {}", (Object)ikex.getMessage());
            throw new XrootdException(3023, "Could not decrypt clientinformation with negotiated key.");
        }
        catch (IOException ioex) {
            this.cancelHandshake();
            LOGGER.error("Could not deserialize main nested buffer {}", (Object)(ioex.getMessage() == null ? ioex.getClass().getName() : ioex.getMessage()));
            throw new XrootdException(10007, "Could not decrypt encrypted client message.");
        }
        catch (GeneralSecurityException gssex) {
            this.cancelHandshake();
            LOGGER.error("Error during decrypting/server-side key exchange: {}", (Object)gssex.getMessage());
            throw new XrootdException(10026, "Error in server-side cryptographic operations.");
        }
    }

    @Override
    public XrootdResponse<AuthenticationRequest> handleSigPxyStep(AuthenticationRequest request, GSIBucketUtils.BucketData data) throws XrootdException {
        try {
            Map<XrootdSecurityProtocol.BucketType, GSIBucket> receivedBuckets = data.getBucketMap();
            NestedBucketBuffer mainBucket = this.decryptMainBucketWithSessionKey(receivedBuckets, "kXGC_sigpxy");
            Map<XrootdSecurityProtocol.BucketType, GSIBucket> nestedBuckets = mainBucket.getNestedBuckets();
            this.rsaSession.initializeForDecryption(this.credentialManager.getSenderPublicKey());
            this.verifySignedRTag(nestedBuckets);
            if (nestedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_x509) == null) {
                StringBucket message = (StringBucket)nestedBuckets.get(XrootdSecurityProtocol.BucketType.kXRS_message);
                LOGGER.info("client cannot sign request; {}.", (Object)(message == null ? "(no message)" : message.getContent()));
                this.cancelHandshake();
            } else {
                X509Certificate[] certChain = this.extractChain(nestedBuckets);
                request.getSession().setDelegatedCredential((Serializable)this.credentialManager.finalizeDelegatedProxy(certChain));
                this.hasProxy = true;
            }
            return new OkResponse((XrootdRequest)request);
        }
        catch (InvalidKeyException ikex) {
            this.cancelHandshake();
            LOGGER.error("The key negotiated by DH key exchange appears to be invalid: {}", (Object)ikex.getMessage());
            throw new XrootdException(3023, "Could not decrypt clientinformation with negotiated key.");
        }
        catch (IOException ioex) {
            this.cancelHandshake();
            LOGGER.error("Could not deserialize main nested buffer {}", (Object)(ioex.getMessage() == null ? ioex.getClass().getName() : ioex.getMessage()));
            throw new XrootdException(10007, "Could not decrypt encrypted client message.");
        }
        catch (GeneralSecurityException gssex) {
            this.cancelHandshake();
            LOGGER.error("Error during decrypting/server-side key exchange: {}", (Object)gssex.getMessage());
            throw new XrootdException(10026, "Error in server-side cryptographic operations.");
        }
    }

    @Override
    public boolean isFinished(GSIBucketUtils.BucketData data) {
        return (this.hasProxy || !this.clientCanSignRequest) && 1001 == data.getStep() || 1002 == data.getStep();
    }

    @Override
    protected String getSyncCipherMode() {
        return "AES/CBC/NoPadding";
    }

    private PublicKey extractClientPublicKey(Map<XrootdSecurityProtocol.BucketType, GSIBucket> buckets) throws NoSuchProviderException, NoSuchAlgorithmException, InvalidKeySpecException {
        StringBucket pukBucket = (StringBucket)buckets.get(XrootdSecurityProtocol.BucketType.kXRS_puk);
        LOGGER.debug("Length of kXRS_puk bucket content: {}, size {}.", (Object)pukBucket.getContent().length(), (Object)pukBucket.getSize());
        byte[] base64 = CertUtil.fromPEM(pukBucket.getContent(), "-----BEGIN PUBLIC KEY-----", "-----END PUBLIC KEY-----");
        LOGGER.debug("resulting base64 byte array length {}.", (Object)base64.length);
        KeyFactory keyfac = KeyFactory.getInstance("RSA", "BC");
        PublicKey key = keyfac.generatePublic(new X509EncodedKeySpec(base64));
        if (key instanceof RSAPublicKey) {
            LOGGER.debug("RSA modulus lenghth: {}.", (Object)((RSAPublicKey)key).getModulus().bitLength());
        }
        return key;
    }

    private AuthenticationResponse getSigPxyResponse(X509Certificate[] certChain, AuthenticationRequest request, NestedBucketBuffer mainBucket) throws XrootdException, NoSuchProviderException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, InvalidAlgorithmParameterException, BadPaddingException, IOException {
        String csr = this.credentialManager.prepareSerializedProxyRequest(certChain);
        PEMCredential credential = this.credentialManager.getHostCredential();
        this.rsaSession.initializeForEncryption(credential.getKey());
        GSIBucket main = this.postProcessMainBucket(mainBucket.getNestedBuckets(), Optional.of(csr), 2002);
        GSIBucketContainer responseBuckets = new ProxyRequestResponse(main, "ssl").buildContainer();
        GSIBucketUtils.BucketSerializer serializer = new GSIBucketUtils.BucketSerializerBuilder().withStreamId(request.getStreamId()).withRequestId(4002).withProtocol("gsi").withStep(2002).withStepName(XrootdSecurityProtocol.getServerStep((int)2002)).withBuckets(responseBuckets.getBuckets()).withTitle("//               Authentication Response").build();
        return new AuthenticationResponse(request, 4002, GSIBucketUtils.getLengthForRequest(responseBuckets), (Consumer)serializer);
    }

    class ProxyRequestResponse
    extends GSIBucketContainerBuilder {
        GSIBucket mainBucket;
        StringBucket cryptoBucket;

        public ProxyRequestResponse(GSIBucket mainBucket, String cryptoMode) {
            this.mainBucket = mainBucket;
            this.cryptoBucket = new StringBucket(XrootdSecurityProtocol.BucketType.kXRS_cryptomod, cryptoMode);
        }

        @Override
        public GSIBucketContainer buildContainer() {
            return ProxyRequestResponse.build(this.mainBucket, this.cryptoBucket);
        }
    }
}

