/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authz.scitokens;

import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import java.util.Map;
import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.AuthorizationHandler;
import org.dcache.xrootd.protocol.XrootdProtocol;
import org.dcache.xrootd.security.RequiresTLS;
import org.dcache.xrootd.security.TokenValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdSciTokenAuthzHandler
implements AuthorizationHandler,
RequiresTLS {
    protected static final Logger LOGGER = LoggerFactory.getLogger(XrootdSciTokenAuthzHandler.class);
    private static final String SCITOKEN = "authz";
    private static final String TPC_STAGE = "tpc.stage";
    private static final String TPC_PLACEMENT = "placement";
    protected final boolean strict;
    protected final TokenValidator validator;
    protected final ChannelHandlerContext ctx;

    public XrootdSciTokenAuthzHandler(TokenValidator validator, boolean strict, ChannelHandlerContext ctx) {
        this.validator = validator;
        this.strict = strict;
        this.ctx = ctx;
    }

    public String authorize(Subject subject, InetSocketAddress localAddress, InetSocketAddress remoteAddress, String path, Map<String, String> opaque, int request, XrootdProtocol.FilePerm mode) throws XrootdException, SecurityException {
        LOGGER.trace("authorize: {}, {}, {}, {}, {}, {}, {}.", new Object[]{subject, localAddress, remoteAddress, path, opaque, request, mode});
        String tpcStage = opaque.get(TPC_STAGE);
        if (TPC_PLACEMENT.equals(tpcStage)) {
            return path;
        }
        String authz = opaque.get(SCITOKEN);
        if (authz == null) {
            LOGGER.debug("no token for {}; strict? {}.", (Object)path, (Object)this.strict);
            if (!this.strict) {
                return path;
            }
            throw new XrootdException(3006, "user provided no bearer token.");
        }
        this.validator.validate(this.ctx, TokenValidator.stripOffPrefix((String)authz));
        return path;
    }
}

