/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.ztn;

import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.AuthenticationHandler;
import org.dcache.xrootd.plugins.authn.ztn.ZTNCredential;
import org.dcache.xrootd.plugins.authn.ztn.ZTNCredentialUtils;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.OkResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;
import org.dcache.xrootd.security.BufferDecrypter;
import org.dcache.xrootd.security.RequiresTLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZTNAuthenticationHandler
implements AuthenticationHandler,
RequiresTLS {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractZTNAuthenticationHandler.class);
    protected Subject subject;
    protected ZTNCredential credential;
    protected Set<String> trustedIssuers;
    private Integer maxTokenSize;
    private List<String> alternateTokenLocations;
    private Long tokenUsageFlags;
    private boolean completed;

    public XrootdResponse<AuthenticationRequest> authenticate(AuthenticationRequest request) throws XrootdException {
        this.subject = new Subject();
        this.credential = ZTNCredentialUtils.deserialize(request.getCredentialBuffer());
        request.releaseBuffer();
        LOGGER.trace("ZTNCredential: {}.", (Object)this.credential);
        if (this.maxTokenSize != null && this.credential.getNullTerminatedTokenLength() > this.maxTokenSize) {
            this.completed = true;
            throw new XrootdException(3002, "token exceeds max length");
        }
        this.validateToken();
        this.completed = true;
        return new OkResponse((XrootdRequest)request);
    }

    public String getProtocol() {
        StringBuilder protocol = new StringBuilder("&P=");
        protocol.append("ztn");
        if (this.hasParams()) {
            protocol.append(",");
            if (this.tokenUsageFlags == null) {
                protocol.append(0L);
            } else {
                protocol.append(this.tokenUsageFlags);
            }
            protocol.append(":");
            if (this.maxTokenSize == null) {
                protocol.append(Integer.MAX_VALUE);
            } else {
                protocol.append(this.maxTokenSize);
            }
            protocol.append(":");
            if (this.alternateTokenLocations != null) {
                StringJoiner joiner = new StringJoiner(",");
                this.alternateTokenLocations.stream().map(s -> (CharSequence)CharSequence.class.cast(s)).forEach(joiner::add);
                protocol.append(joiner.toString());
            }
        }
        LOGGER.debug("Protocol: {}.", (Object)protocol.toString());
        return protocol.toString();
    }

    public Subject getSubject() {
        return this.subject;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public BufferDecrypter getDecrypter() {
        return null;
    }

    public void setMaxTokenSize(Integer maxTokenSize) {
        this.maxTokenSize = maxTokenSize;
    }

    public void setAlternateTokenLocations(List<String> alternateTokenLocations) {
        this.alternateTokenLocations = alternateTokenLocations;
    }

    public void setTokenUsageFlags(Long tokenUsageFlags) {
        this.tokenUsageFlags = tokenUsageFlags;
    }

    public void setTrustedIssuers(Set<String> trustedIssuers) {
        this.trustedIssuers = trustedIssuers;
    }

    private boolean hasParams() {
        return this.maxTokenSize != null || this.tokenUsageFlags != null || this.alternateTokenLocations != null;
    }

    protected abstract void validateToken() throws XrootdException;
}

