/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.ztn;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.function.Consumer;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.authn.ztn.ZTNCredential;
import org.dcache.xrootd.plugins.authn.ztn.ZTNCredentialUtils;
import org.dcache.xrootd.security.SigningPolicy;
import org.dcache.xrootd.security.TLSSessionInfo;
import org.dcache.xrootd.security.TokenValidator;
import org.dcache.xrootd.tpc.AbstractClientAuthnHandler;
import org.dcache.xrootd.tpc.TpcSigverRequestEncoder;
import org.dcache.xrootd.tpc.XrootdTpcInfo;
import org.dcache.xrootd.tpc.protocol.messages.InboundAuthenticationResponse;
import org.dcache.xrootd.tpc.protocol.messages.OutboundAuthenticationRequest;

public class ZTNClientAuthenticationHandler
extends AbstractClientAuthnHandler {
    private static final int VERSION = 0;
    private static final byte OPR = 84;

    public ZTNClientAuthenticationHandler() {
        super("ztn");
    }

    protected void doOnAuthenticationResponse(ChannelHandlerContext ctx, InboundAuthenticationResponse response) throws XrootdException {
        ChannelId id = ctx.channel().id();
        int status = response.getStatus();
        int streamId = this.client.getStreamId();
        XrootdTpcInfo tpcInfo = this.client.getInfo();
        switch (status) {
            case 0: {
                LOGGER.debug("Authentication to {}, channel {}, stream {}, sessionId {} succeeded; passing to next handler.", new Object[]{tpcInfo.getSrc(), id, streamId, this.client.getSessionId()});
                ctx.fireChannelRead((Object)response);
                break;
            }
            default: {
                throw new XrootdException(4003, "failed with status " + status);
            }
        }
    }

    protected void sendAuthenticationRequest(ChannelHandlerContext ctx) throws XrootdException {
        String token;
        LOGGER.warn("TPC with ztn and scitokens is not yet established; this is not guaranteed to work with version 0.");
        SigningPolicy signingPolicy = this.client.getSigningPolicy();
        TLSSessionInfo tlsSessionInfo = this.client.getTlsSessionInfo();
        if (signingPolicy.isSigningOn()) {
            TpcSigverRequestEncoder sigverRequestEncoder = new TpcSigverRequestEncoder(null, signingPolicy);
            ctx.pipeline().addAfter("encoder", "sigverEncoder", (ChannelHandler)sigverRequestEncoder);
            LOGGER.debug("optional signed hash verification encoder has been added; this is unusual for ZTN:signing is on? {}; tls ? {}.", (Object)signingPolicy.isSigningOn(), (Object)tlsSessionInfo.getClientTls());
        }
        if ((token = this.client.getInfo().getSourceToken()) == null) {
            throw new XrootdException(3010, "TPC was not provided a ztn token.");
        }
        token = TokenValidator.stripOffPrefix((String)token);
        LOGGER.debug("sendAuthenticationRequest, source token is {}.", (Object)token);
        ZTNCredential credential = new ZTNCredential();
        credential.setVersion(0);
        credential.setOpr((byte)84);
        credential.setTokenLength(token.length());
        credential.setToken(token);
        Consumer<ByteBuf> serializer = b -> ZTNCredentialUtils.writeBytes(b, credential);
        OutboundAuthenticationRequest request = new OutboundAuthenticationRequest(this.client.getStreamId(), "ztn", credential.getLength(), serializer);
        this.client.setExpectedResponse(3000);
        this.client.setAuthResponse(null);
        ctx.writeAndFlush((Object)request, ctx.newPromise()).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        this.client.startTimer(ctx);
    }
}

