/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.ztn;

import com.google.common.base.Strings;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.core.XrootdDecoder;
import org.dcache.xrootd.core.XrootdEncoder;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.plugins.authn.ztn.ZTNCredential;
import org.dcache.xrootd.security.TokenValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZTNCredentialUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZTNCredentialUtils.class);

    public static ZTNCredential deserialize(ByteBuf buffer) throws XrootdException {
        ZTNCredential credential = new ZTNCredential();
        String protocol = XrootdDecoder.readAscii((ByteBuf)buffer, (int)4);
        if (!"ztn".equals(protocol)) {
            String error = "protocol " + protocol + "  does not match " + "ztn" + "; this is a bug.";
            throw new IllegalArgumentException(error);
        }
        credential.setVersion(buffer.readByte());
        credential.setOpr(buffer.readByte());
        buffer.readByte();
        buffer.readByte();
        short len = buffer.readShort();
        if (len <= 1) {
            throw new XrootdException(3000, "illegal token length");
        }
        String token = Strings.emptyToNull((String)XrootdDecoder.readAscii((ByteBuf)buffer, (int)len));
        if (token == null) {
            throw new XrootdException(3001, "no token");
        }
        token = TokenValidator.stripOffPrefix((String)token);
        credential.setTokenLength(token.length());
        credential.setToken(token);
        LOGGER.debug("deserialize, got credential {}.", (Object)credential);
        return credential;
    }

    public static void writeBytes(ByteBuf buffer, ZTNCredential credential) {
        XrootdEncoder.writeZeroPad((String)"ztn", (ByteBuf)buffer, (int)4);
        buffer.writeByte(credential.getVersion());
        buffer.writeByte((int)credential.getOpr());
        buffer.writeZero(2);
        buffer.writeShort(credential.getNullTerminatedTokenLength());
        buffer.writeBytes(credential.getToken().getBytes(StandardCharsets.US_ASCII));
        buffer.writeByte(0);
    }
}

