/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.plugins.authn.ztn;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.dcache.xrootd.plugins.AuthenticationFactory;

public abstract class AbstractZTNAuthenticationFactory
implements AuthenticationFactory {
    private static final String MAX_TOKEN_SZ = "xrootd.plugin!ztn.max-token-len-in-bytes";
    private static final String TOKEN_FLAGS = "xrootd.plugin!ztn.token-flags";
    private static final String ALT_TOKEN_LOCS = "xrootd.plugin!ztn.alt-token-locs";
    protected Integer maxTokenSize;
    protected Long tokenUsageFlags;
    protected List<String> alternateTokenLocations;

    protected AbstractZTNAuthenticationFactory(Properties properties) throws ClassNotFoundException {
        String property = Strings.emptyToNull((String)properties.getProperty(MAX_TOKEN_SZ));
        if (property != null) {
            this.maxTokenSize = Integer.valueOf(property);
        }
        if ((property = Strings.emptyToNull((String)properties.getProperty(TOKEN_FLAGS))) != null) {
            this.tokenUsageFlags = Long.valueOf(property);
        }
        if ((property = Strings.emptyToNull((String)properties.getProperty(ALT_TOKEN_LOCS))) != null) {
            this.alternateTokenLocations = Arrays.asList(property.split(","));
        }
    }
}

