/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.CloseRequest;
import org.dcache.xrootd.protocol.messages.DirListRequest;
import org.dcache.xrootd.protocol.messages.ErrorResponse;
import org.dcache.xrootd.protocol.messages.LoginRequest;
import org.dcache.xrootd.protocol.messages.MkDirRequest;
import org.dcache.xrootd.protocol.messages.MvRequest;
import org.dcache.xrootd.protocol.messages.OkResponse;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.protocol.messages.PrepareRequest;
import org.dcache.xrootd.protocol.messages.ProtocolRequest;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.protocol.messages.RmDirRequest;
import org.dcache.xrootd.protocol.messages.RmRequest;
import org.dcache.xrootd.protocol.messages.StatRequest;
import org.dcache.xrootd.protocol.messages.StatxRequest;
import org.dcache.xrootd.protocol.messages.SyncRequest;
import org.dcache.xrootd.protocol.messages.WriteRequest;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.handler.timeout.IdleStateAwareChannelHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdRequestHandler
extends IdleStateAwareChannelHandler {
    private static final Logger _log = LoggerFactory.getLogger(XrootdRequestHandler.class);

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        Object msg = event.getMessage();
        if (msg instanceof XrootdRequest) {
            this.requestReceived(ctx, event, (XrootdRequest)msg);
        }
    }

    protected void requestReceived(ChannelHandlerContext ctx, MessageEvent event, XrootdRequest req) {
        try {
            AbstractResponseMessage response;
            switch (req.getRequestId()) {
                case 3000: {
                    response = this.doOnAuthentication(ctx, event, (AuthenticationRequest)req);
                    break;
                }
                case 3007: {
                    response = this.doOnLogin(ctx, event, (LoginRequest)req);
                    break;
                }
                case 3010: {
                    response = this.doOnOpen(ctx, event, (OpenRequest)req);
                    break;
                }
                case 3017: {
                    response = this.doOnStat(ctx, event, (StatRequest)req);
                    break;
                }
                case 3022: {
                    response = this.doOnStatx(ctx, event, (StatxRequest)req);
                    break;
                }
                case 3013: {
                    response = this.doOnRead(ctx, event, (ReadRequest)req);
                    break;
                }
                case 3025: {
                    response = this.doOnReadV(ctx, event, (ReadVRequest)req);
                    break;
                }
                case 3019: {
                    response = this.doOnWrite(ctx, event, (WriteRequest)req);
                    break;
                }
                case 3016: {
                    response = this.doOnSync(ctx, event, (SyncRequest)req);
                    break;
                }
                case 3003: {
                    response = this.doOnClose(ctx, event, (CloseRequest)req);
                    break;
                }
                case 3006: {
                    response = this.doOnProtocolRequest(ctx, event, (ProtocolRequest)req);
                    break;
                }
                case 3014: {
                    response = this.doOnRm(ctx, event, (RmRequest)req);
                    break;
                }
                case 3015: {
                    response = this.doOnRmDir(ctx, event, (RmDirRequest)req);
                    break;
                }
                case 3008: {
                    response = this.doOnMkDir(ctx, event, (MkDirRequest)req);
                    break;
                }
                case 3009: {
                    response = this.doOnMv(ctx, event, (MvRequest)req);
                    break;
                }
                case 3004: {
                    response = this.doOnDirList(ctx, event, (DirListRequest)req);
                    break;
                }
                case 3021: {
                    response = this.doOnPrepare(ctx, event, (PrepareRequest)req);
                    break;
                }
                default: {
                    response = this.unsupported(ctx, event, req);
                }
            }
            if (response != null) {
                this.respond(ctx, event, response);
            }
        }
        catch (XrootdException e) {
            this.respond(ctx, event, this.withError(req, e.getError(), e.getMessage()));
        }
        catch (RuntimeException e) {
            _log.error(String.format("Processing %s failed due to a bug", req), (Throwable)e);
            this.respond(ctx, event, this.withError(req, 3012, String.format("Internal server error (%s)", e.getMessage())));
        }
    }

    protected OkResponse withOk(XrootdRequest req) {
        return new OkResponse(req.getStreamId());
    }

    protected ErrorResponse withError(XrootdRequest req, int errorCode, String errMsg) {
        return new ErrorResponse(req.getStreamId(), errorCode, errMsg);
    }

    protected ChannelFuture respond(ChannelHandlerContext ctx, MessageEvent e, AbstractResponseMessage msg) {
        return e.getChannel().write((Object)msg);
    }

    protected AbstractResponseMessage unsupported(ChannelHandlerContext ctx, MessageEvent e, XrootdRequest msg) throws XrootdException {
        _log.warn("Unsupported request: " + msg);
        throw new XrootdException(3013, "Request " + msg.getRequestId() + " not supported");
    }

    protected AbstractResponseMessage doOnLogin(ChannelHandlerContext ctx, MessageEvent e, LoginRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnAuthentication(ChannelHandlerContext ctx, MessageEvent e, AuthenticationRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnOpen(ChannelHandlerContext ctx, MessageEvent e, OpenRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnStat(ChannelHandlerContext ctx, MessageEvent e, StatRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnStatx(ChannelHandlerContext ctx, MessageEvent e, StatxRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnRead(ChannelHandlerContext ctx, MessageEvent e, ReadRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnReadV(ChannelHandlerContext ctx, MessageEvent e, ReadVRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnWrite(ChannelHandlerContext ctx, MessageEvent e, WriteRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnSync(ChannelHandlerContext ctx, MessageEvent e, SyncRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnClose(ChannelHandlerContext ctx, MessageEvent e, CloseRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnProtocolRequest(ChannelHandlerContext ctx, MessageEvent e, ProtocolRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnRm(ChannelHandlerContext ctx, MessageEvent e, RmRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnRmDir(ChannelHandlerContext ctx, MessageEvent e, RmDirRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnMkDir(ChannelHandlerContext ctx, MessageEvent e, MkDirRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnMv(ChannelHandlerContext ctx, MessageEvent e, MvRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnDirList(ChannelHandlerContext ctx, MessageEvent e, DirListRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }

    protected AbstractResponseMessage doOnPrepare(ChannelHandlerContext ctx, MessageEvent e, PrepareRequest msg) throws XrootdException {
        return this.unsupported(ctx, e, msg);
    }
}

