/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.EnumMap;
import java.util.Map;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationRequest
extends XrootdRequest {
    private static final Logger _logger = LoggerFactory.getLogger(AuthenticationRequest.class);
    private static final int MAX_BUCKET_LENGTH = 10000;
    private String _protocol;
    private int _step;
    private Map<XrootdSecurityProtocol.BucketType, XrootdBucket> _bucketMap = new EnumMap<XrootdSecurityProtocol.BucketType, XrootdBucket>(XrootdSecurityProtocol.BucketType.class);

    public AuthenticationRequest(ChannelBuffer buffer) {
        super(buffer, 3000);
        buffer.readerIndex(24);
        this._protocol = AuthenticationRequest.deserializeProtocol(buffer);
        this._step = AuthenticationRequest.deserializeStep(buffer);
        try {
            this._bucketMap.putAll(AuthenticationRequest.deserializeBuckets(buffer));
        }
        catch (IOException ioex) {
            throw new IllegalArgumentException("Illegal credential format: {}", ioex);
        }
    }

    public static Map<XrootdSecurityProtocol.BucketType, XrootdBucket> deserializeBuckets(ChannelBuffer buffer) throws IOException {
        int bucketCode = buffer.readInt();
        XrootdSecurityProtocol.BucketType bucketType = XrootdSecurityProtocol.BucketType.get(bucketCode);
        _logger.debug("Deserializing a bucket with code {}", (Object)bucketCode);
        EnumMap<XrootdSecurityProtocol.BucketType, XrootdBucket> buckets = new EnumMap<XrootdSecurityProtocol.BucketType, XrootdBucket>(XrootdSecurityProtocol.BucketType.class);
        while (bucketType != XrootdSecurityProtocol.BucketType.kXRS_none) {
            int bucketLength = buffer.readInt();
            if (bucketLength > 10000) {
                throw new IOException("Encountered a bucket with length " + bucketLength + ". Maximum allowed bucket " + "length " + 10000);
            }
            XrootdBucket bucket = XrootdBucket.deserialize(bucketType, buffer.slice(buffer.readerIndex(), bucketLength));
            buckets.put(bucketType, bucket);
            buffer.readerIndex(buffer.readerIndex() + bucketLength);
            bucketCode = buffer.readInt();
            bucketType = XrootdSecurityProtocol.BucketType.get(bucketCode);
        }
        return buckets;
    }

    public static String deserializeProtocol(ChannelBuffer buffer) {
        String protocol = buffer.toString(buffer.readerIndex(), 4, Charset.forName("ASCII")).trim();
        buffer.readerIndex(buffer.readerIndex() + 4);
        return protocol;
    }

    public static int deserializeStep(ChannelBuffer buffer) {
        int step = buffer.readInt();
        return step;
    }

    public Map<XrootdSecurityProtocol.BucketType, XrootdBucket> getBuckets() {
        return this._bucketMap;
    }

    public int getStep() {
        return this._step;
    }

    public String getProtocol() {
        return this._protocol;
    }
}

