/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import java.util.Iterator;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirListResponse
extends AbstractResponseMessage {
    public DirListResponse(int streamid, int statusCode, Iterable<String> names) {
        super(streamid, statusCode, DirListResponse.computeResponseSize(names));
        Iterator<String> i = names.iterator();
        if (i.hasNext()) {
            this.putCharSequence(i.next());
            while (i.hasNext()) {
                this.putUnsignedChar(10);
                this.putCharSequence(i.next());
            }
            if (statusCode == 4000) {
                this.putUnsignedChar(10);
            } else {
                this.putUnsignedChar(0);
            }
        }
    }

    public DirListResponse(int streamid, Iterable<String> names) {
        this(streamid, 0, names);
    }

    private static int computeResponseSize(Iterable<String> names) {
        int length = 0;
        for (String name : names) {
            length += name.length() + 1;
        }
        return length;
    }
}

