/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.jboss.netty.buffer.ChannelBuffer;

public class LoginRequest
extends XrootdRequest {
    private final String _username;
    private final short _role;
    private final short _capver;
    private final int _pid;
    private final String _token;

    public LoginRequest(ChannelBuffer buffer) {
        super(buffer, 3007);
        int pos = buffer.indexOf(8, 16, (byte)0);
        this._username = pos > -1 ? buffer.toString(8, pos - 8, XROOTD_CHARSET) : buffer.toString(8, 8, XROOTD_CHARSET);
        this._pid = buffer.getInt(4);
        this._capver = buffer.getUnsignedByte(18);
        this._role = buffer.getUnsignedByte(19);
        int tlen = buffer.getInt(20);
        this._token = buffer.toString(24, tlen, XROOTD_CHARSET);
    }

    public String getUserName() {
        return this._username;
    }

    public boolean supportsAsyn() {
        return (this._capver & 0x80) == 128;
    }

    public int getClientProtocolVersion() {
        return this._capver & 0x3F;
    }

    public boolean isAdmin() {
        return this._role == 1;
    }

    public int getPID() {
        return this._pid;
    }

    public String getToken() {
        return this._token;
    }
}

