/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.jboss.netty.buffer.ChannelBuffer;

public class MvRequest
extends XrootdRequest {
    private String _sourcePath;
    private String _targetPath;
    private String _opaque;

    public MvRequest(ChannelBuffer buffer) {
        super(buffer, 3009);
        int dlen = buffer.getInt(20);
        int end = 24 + dlen;
        int psep = buffer.indexOf(24, end, (byte)32);
        int osep = buffer.indexOf(psep, end, (byte)63);
        if (psep == -1) {
            throw new IllegalArgumentException("kXR_mv needs two paths!");
        }
        if (osep > -1) {
            this._sourcePath = buffer.toString(24, psep - 24, XROOTD_CHARSET);
            this._targetPath = buffer.toString(psep + 1, osep - (psep + 1), XROOTD_CHARSET);
            this._opaque = buffer.toString(osep + 1, end - (osep + 1), XROOTD_CHARSET);
        } else {
            this._sourcePath = buffer.toString(24, psep - 24, XROOTD_CHARSET);
            this._targetPath = buffer.toString(psep + 1, end - (psep + 1), XROOTD_CHARSET);
            this._opaque = null;
        }
    }

    public void setOpaque(String opaque) {
        this._opaque = opaque;
    }

    public String getOpaque() {
        return this._opaque;
    }

    public void setSourcePath(String sourcePath) {
        this._sourcePath = sourcePath;
    }

    public String getSourcePath() {
        return this._sourcePath;
    }

    public void setTargetPath(String targetPath) {
        this._targetPath = targetPath;
    }

    public String getTargetPath() {
        return this._targetPath;
    }
}

