/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import java.util.Arrays;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.jboss.netty.buffer.ChannelBuffer;

public class PrepareRequest
extends XrootdRequest {
    private final int _options;
    private final int _priority;
    private final String[] _plist;

    public PrepareRequest(ChannelBuffer buffer) {
        super(buffer, 3021);
        this._options = buffer.getUnsignedShort(4);
        this._priority = buffer.getUnsignedShort(5);
        int plen = buffer.getInt(20);
        int end = 24 + plen;
        this._plist = buffer.toString(24, end - 24, XROOTD_CHARSET).split("\n");
    }

    public int getOptions() {
        return this._options;
    }

    public int getPriority() {
        return this._priority;
    }

    public String[] getPathList() {
        return this._plist;
    }

    public boolean isCancel() {
        return (this.getOptions() & 1) == 1;
    }

    public boolean isNotify() {
        return (this.getOptions() & 2) == 2;
    }

    public boolean isNoErrors() {
        return (this.getOptions() & 4) == 4;
    }

    public boolean isStage() {
        return (this.getOptions() & 8) == 8;
    }

    public boolean isWriteMode() {
        return (this.getOptions() & 0x10) == 16;
    }

    public boolean isColocate() {
        return (this.getOptions() & 0x20) == 32;
    }

    public boolean isFresh() {
        return (this.getOptions() & 0x40) == 64;
    }

    public String toString() {
        return String.format("prepare[%d,%d,%s]", this._options, this._priority, Arrays.toString(this._plist));
    }
}

