/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import java.io.IOException;
import java.nio.channels.ScatteringByteChannel;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.GenericReadRequestMessage;

public class ReadResponse
extends AbstractResponseMessage {
    public static final int READ_LIST_HEADER_SIZE = 16;

    public ReadResponse(int sId, int length) {
        super(sId, 0, length);
    }

    public void setIncomplete(boolean incomplete) {
        this.setStatus(incomplete ? 4000 : 0);
    }

    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        return this._buffer.writeBytes(in, length);
    }

    public int writeBytes(GenericReadRequestMessage.EmbeddedReadRequest req) {
        this.putSignedInt(req.getFileHandle());
        this.putSignedInt(req.BytesToRead());
        this.putSignedLong(req.getOffset());
        return 16;
    }

    public int getDataLength() {
        return this._buffer.readableBytes() - 8;
    }

    public String toString() {
        return String.format("read-response[length=%d]", this.getDataLength());
    }
}

