/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.Preconditions;
import java.nio.charset.Charset;
import javax.security.auth.Subject;
import org.jboss.netty.buffer.ChannelBuffer;

public abstract class XrootdRequest {
    protected static final Charset XROOTD_CHARSET = Charset.forName("ASCII");
    protected final int _streamId;
    protected final int _requestId;
    protected Subject _subject;

    public XrootdRequest() {
        this._streamId = 0;
        this._requestId = 0;
    }

    public XrootdRequest(ChannelBuffer buffer, int requestId) {
        this(buffer);
        Preconditions.checkState((this._requestId == requestId ? 1 : 0) != 0);
    }

    public XrootdRequest(ChannelBuffer buffer) {
        this._streamId = buffer.getUnsignedShort(0);
        this._requestId = buffer.getUnsignedShort(2);
    }

    public int getStreamId() {
        return this._streamId;
    }

    public int getRequestId() {
        return this._requestId;
    }

    public void setSubject(Subject subject) {
        this._subject = subject;
    }

    public Subject getSubject() {
        return this._subject;
    }
}

