/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.security;

import java.io.IOException;
import java.util.Map;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedBucketBuffer
extends XrootdBucket {
    private static final Logger _logger = LoggerFactory.getLogger(NestedBucketBuffer.class);
    private Map<XrootdSecurityProtocol.BucketType, XrootdBucket> _nestedBuckets;
    private String _protocol;
    private int _step;

    public NestedBucketBuffer(XrootdSecurityProtocol.BucketType type, String protocol, int step, Map<XrootdSecurityProtocol.BucketType, XrootdBucket> nestedBuckets) {
        super(type);
        this._protocol = protocol;
        this._step = step;
        this._nestedBuckets = nestedBuckets;
    }

    public static NestedBucketBuffer deserialize(XrootdSecurityProtocol.BucketType type, ChannelBuffer buffer) throws IOException {
        int readIndex = buffer.readerIndex();
        String protocol = AuthenticationRequest.deserializeProtocol(buffer);
        int step = AuthenticationRequest.deserializeStep(buffer);
        _logger.debug("NestedBucketBuffer protocol: {}, step {}", (Object)protocol, (Object)step);
        if (step < 1000 || step > 1003) {
            buffer.readerIndex(readIndex);
            throw new IOException("Buffer contents are not a nested buffer!");
        }
        NestedBucketBuffer bucket = new NestedBucketBuffer(type, protocol, step, AuthenticationRequest.deserializeBuckets(buffer));
        return bucket;
    }

    public Map<XrootdSecurityProtocol.BucketType, XrootdBucket> getNestedBuckets() {
        return this._nestedBuckets;
    }

    public int getStep() {
        return this._step;
    }

    public String getProtocol() {
        return this._protocol;
    }

    @Override
    public void serialize(ChannelBuffer out) {
        super.serialize(out);
        int currentpos = out.writerIndex();
        out.writeInt(0);
        out.writeBytes(this._protocol.getBytes());
        int padding = 4 - this._protocol.getBytes().length;
        for (int i = 0; i < padding; ++i) {
            out.writeByte(0);
        }
        out.writeInt(this._step);
        for (XrootdBucket bucket : this._nestedBuckets.values()) {
            bucket.serialize(out);
        }
        out.writeInt(XrootdSecurityProtocol.BucketType.kXRS_none.getCode());
        int nestedBucketBufferLength = out.writerIndex() - currentpos - 4;
        out.writerIndex(currentpos);
        out.writeInt(nestedBucketBufferLength);
        out.writerIndex(out.writerIndex() + nestedBucketBufferLength);
    }

    @Override
    public int getSize() {
        int size = super.getSize();
        for (XrootdBucket bucket : this._nestedBuckets.values()) {
            size += bucket.getSize();
        }
        return size;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append("begin nested BucketBuffer\n");
        for (XrootdBucket bucket : this._nestedBuckets.values()) {
            sb.append(bucket.toString());
        }
        sb.append("end nested BucketBuffer\n");
        return sb.toString();
    }
}

