/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.security;

import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.jboss.netty.buffer.ChannelBuffer;

public class RawBucket
extends XrootdBucket {
    private byte[] _data;

    public RawBucket(XrootdSecurityProtocol.BucketType type, byte[] data) {
        super(type);
        this._data = data;
    }

    public byte[] getContent() {
        return this._data;
    }

    public static RawBucket deserialize(XrootdSecurityProtocol.BucketType type, ChannelBuffer buffer) {
        byte[] tmp = new byte[buffer.readableBytes()];
        buffer.getBytes(0, tmp);
        RawBucket bucket = new RawBucket(type, tmp);
        return bucket;
    }

    public void serialize(ChannelBuffer out) {
        super.serialize(out);
        out.writeInt(this._data.length);
        out.writeBytes(this._data);
    }

    public int getSize() {
        return super.getSize() + 4 + this._data.length;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString() + " hex dump:");
        for (int i = 0; i < this._data.length; ++i) {
            sb.append(" ").append(Integer.toHexString(this._data[i]));
        }
        return sb.toString();
    }
}

