/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.security;

import java.nio.charset.Charset;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.jboss.netty.buffer.ChannelBuffer;

public class StringBucket
extends XrootdBucket {
    private String _data;

    public StringBucket(XrootdSecurityProtocol.BucketType type, String data) {
        super(type);
        this._data = data;
    }

    public String getContent() {
        return this._data;
    }

    public static StringBucket deserialize(XrootdSecurityProtocol.BucketType type, ChannelBuffer buffer) {
        String s = buffer.toString(Charset.forName("ASCII"));
        StringBucket bucket = new StringBucket(type, s);
        return bucket;
    }

    public void serialize(ChannelBuffer out) {
        super.serialize(out);
        out.writeInt(this._data.length());
        out.writeBytes(this._data.getBytes());
    }

    public int getSize() {
        return super.getSize() + 4 + this._data.getBytes().length;
    }

    public String toString() {
        return super.toString() + this._data;
    }
}

