/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import java.util.List;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;

public class AuthenticationResponse
extends AbstractResponseMessage {
    public AuthenticationResponse(XrootdRequest request, int status, int length) {
        super(request, status, length);
    }

    public AuthenticationResponse(XrootdRequest request, int status, int length, String protocol, int step, List<XrootdBucket> buckets) {
        super(request, status, length);
        if (protocol.length() > 4) {
            throw new IllegalArgumentException("Protocol length must not exceed 4. The passed protocol is " + protocol);
        }
        this.putCharSequence(protocol);
        int padding = 4 - protocol.getBytes().length;
        for (int i = 0; i < padding; ++i) {
            this._buffer.writeByte(0);
        }
        this.putSignedInt(step);
        for (XrootdBucket bucket : buckets) {
            bucket.serialize(this._buffer);
        }
        this.putSignedInt(XrootdSecurityProtocol.BucketType.kXRS_none.getCode());
    }
}

