/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import java.util.Iterator;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.XrootdRequest;

public class DirListResponse
extends AbstractResponseMessage {
    public DirListResponse(XrootdRequest request, int statusCode, Iterable<String> names) {
        super(request, statusCode, DirListResponse.computeResponseSize(names));
        Iterator<String> i = names.iterator();
        if (i.hasNext()) {
            this.putCharSequence(i.next());
            while (i.hasNext()) {
                this.putUnsignedChar(10);
                this.putCharSequence(i.next());
            }
            if (statusCode == 4000) {
                this.putUnsignedChar(10);
            } else {
                this.putUnsignedChar(0);
            }
        }
    }

    public DirListResponse(XrootdRequest request, Iterable<String> names) {
        this(request, 0, names);
    }

    private static int computeResponseSize(Iterable<String> names) {
        int length = 0;
        for (String name : names) {
            length += name.length() + 1;
        }
        return length;
    }
}

