/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.jboss.netty.buffer.ChannelBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GenericReadRequestMessage
extends XrootdRequest {
    private static final Logger _log = LoggerFactory.getLogger(GenericReadRequestMessage.class);
    private final int pathid;
    private final EmbeddedReadRequest[] readList;

    public GenericReadRequestMessage(ChannelBuffer buffer, int requestId) {
        super(buffer, requestId);
        int alen = buffer.getInt(20);
        if (alen <= 8) {
            this.pathid = -1;
            this.readList = new EmbeddedReadRequest[0];
        } else {
            int prefix = 0;
            if (alen % 16 == 0) {
                this.pathid = -1;
            } else if (alen % 16 != 8) {
                this.pathid = -1;
                _log.warn("invalid readv request: data doesn't start with 8 byte prefix (pathid)");
            } else {
                this.pathid = buffer.getUnsignedByte(24);
                prefix = 8;
            }
            int numberOfListEntries = (alen - prefix) / 16;
            this.readList = new EmbeddedReadRequest[numberOfListEntries];
            for (int i = 0; i < numberOfListEntries; ++i) {
                int j = 24 + prefix + i * 16;
                this.readList[i] = new EmbeddedReadRequest(buffer.getInt(j), buffer.getInt(j + 4), buffer.getLong(j + 8));
            }
        }
    }

    public int getPathID() {
        return this.pathid;
    }

    protected int getSizeOfList() {
        return this.readList.length;
    }

    protected EmbeddedReadRequest[] getReadRequestList() {
        return this.readList;
    }

    public static class EmbeddedReadRequest {
        private final int fh;
        private final int len;
        private final long offs;

        EmbeddedReadRequest(int fh, int len, long offs) {
            this.fh = fh;
            this.len = len;
            this.offs = offs;
        }

        public int getFileHandle() {
            return this.fh;
        }

        public int BytesToRead() {
            return this.len;
        }

        public long getOffset() {
            return this.offs;
        }

        public String toString() {
            return String.format("(%d,%d,%d)", this.fh, this.len, this.offs);
        }
    }
}

