/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.jboss.netty.buffer.ChannelBuffer;

public class PathRequest
extends XrootdRequest {
    private static final byte OPAQUE_DELIMITER = 63;
    private String _path;
    private String _opaque;

    public PathRequest() {
    }

    public PathRequest(ChannelBuffer buffer, int requestId) {
        super(buffer, requestId);
        this.setPathAndOpaque(buffer, 24, buffer.getInt(20));
    }

    private void setPathAndOpaque(ChannelBuffer buffer, int begin, int length) {
        int end = begin + length;
        int pos = buffer.indexOf(begin, end, (byte)63);
        if (pos > -1) {
            this.setPath(buffer.toString(begin, pos - begin, XROOTD_CHARSET));
            this.setOpaque(buffer.toString(pos + 1, end - (pos + 1), XROOTD_CHARSET));
        } else {
            this.setPath(buffer.toString(begin, end - begin, XROOTD_CHARSET));
            this.setOpaque("");
        }
    }

    public String getOpaque() {
        return this._opaque;
    }

    public void setOpaque(String opaque) {
        this._opaque = opaque;
    }

    public String getPath() {
        return this._path;
    }

    public void setPath(String path) {
        this._path = path;
    }
}

