/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import java.io.IOException;
import java.nio.channels.ScatteringByteChannel;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.GenericReadRequestMessage;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class ReadResponse
extends AbstractResponseMessage {
    public static final int READ_LIST_HEADER_SIZE = 16;

    public ReadResponse(XrootdRequest request, int length) {
        super(request, 0, length);
    }

    public void setIncomplete(boolean incomplete) {
        this.setStatus(incomplete ? 4000 : 0);
    }

    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        return this._buffer.writeBytes(in, length);
    }

    public int writeBytes(GenericReadRequestMessage.EmbeddedReadRequest req) {
        this.putSignedInt(req.getFileHandle());
        this.putSignedInt(req.BytesToRead());
        this.putSignedLong(req.getOffset());
        return 16;
    }

    private ChannelBuffer createReadListHeader(GenericReadRequestMessage.EmbeddedReadRequest request, int actualLength) {
        ChannelBuffer buffer = ChannelBuffers.buffer((int)16);
        buffer.writeInt(request.getFileHandle());
        buffer.writeInt(actualLength);
        buffer.writeLong(request.getOffset());
        return buffer;
    }

    public void write(GenericReadRequestMessage.EmbeddedReadRequest[] requests, ChannelBuffer[] buffers, int offset, int length) {
        ChannelBuffer[] reply = new ChannelBuffer[2 * length + 1];
        reply[0] = this._buffer;
        for (int i = 0; i < length; ++i) {
            reply[2 * i + 1] = this.createReadListHeader(requests[offset + i], buffers[offset + i].readableBytes());
            reply[2 * i + 2] = buffers[offset + i];
        }
        this._buffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])reply);
    }

    public void append(ChannelBuffer buffer) {
        this._buffer = ChannelBuffers.wrappedBuffer((ChannelBuffer[])new ChannelBuffer[]{this._buffer, buffer});
    }

    public int getDataLength() {
        return this._buffer.readableBytes() - 8;
    }

    public String toString() {
        return String.format("read-response[length=%d]", this.getDataLength());
    }
}

