/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.jboss.netty.buffer.ChannelBuffer;

public class WriteRequest
extends XrootdRequest {
    private final int _fhandle;
    private final long _offset;
    private final int _dlen;
    private final ChannelBuffer _buffer;

    public WriteRequest(ChannelBuffer buffer) {
        super(buffer, 3019);
        this._fhandle = buffer.getInt(4);
        this._offset = buffer.getLong(8);
        this._dlen = buffer.getInt(20);
        this._buffer = buffer;
    }

    public int getFileHandle() {
        return this._fhandle;
    }

    public long getWriteOffset() {
        return this._offset;
    }

    public int getDataLength() {
        return this._dlen;
    }

    public void getData(GatheringByteChannel out) throws IOException {
        int written;
        int index = 24;
        for (int len = this._dlen; len > 0; len -= written) {
            written = this._buffer.getBytes(index, out, len);
            index += written;
        }
    }

    public ByteBuffer[] toByteBuffers() {
        return this._buffer.toByteBuffers(24, this._dlen);
    }

    public String toString() {
        return String.format("write[handle=%d,offset=%d,length=%d]", this._fhandle, this._offset, this._dlen);
    }
}

