/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.stream;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.stream.AbstractChunkedReadvResponse;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class ChunkedFileReadvResponse
extends AbstractChunkedReadvResponse {
    private final List<RandomAccessFile> files;

    public ChunkedFileReadvResponse(ReadVRequest request, int maxFrameSize, List<RandomAccessFile> files) {
        super(request, maxFrameSize);
        this.files = files;
    }

    @Override
    protected long getSize(int fd) throws IOException, XrootdException {
        if (fd < 0 || fd >= this.files.size() || this.files.get(fd) == null) {
            throw new XrootdException(3004, "Invalid file descriptor");
        }
        return this.files.get(fd).length();
    }

    @Override
    protected ChannelBuffer read(int fd, long position, int length) throws IOException, XrootdException {
        int bytes;
        if (fd < 0 || fd >= this.files.size() || this.files.get(fd) == null) {
            throw new XrootdException(3004, "Invalid file descriptor");
        }
        FileChannel channel = this.files.get(fd).getChannel();
        byte[] chunkArray = new byte[length];
        ByteBuffer chunk = ByteBuffer.wrap(chunkArray);
        while (length > 0 && (bytes = channel.read(chunk, position)) >= 0) {
            position += (long)bytes;
            length -= bytes;
        }
        return ChannelBuffers.wrappedBuffer((byte[])chunkArray, (int)0, (int)(chunkArray.length - length));
    }
}

