/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.core.XrootdSession;
import org.dcache.xrootd.core.XrootdSessionIdentifier;
import org.dcache.xrootd.plugins.AuthenticationFactory;
import org.dcache.xrootd.plugins.AuthenticationHandler;
import org.dcache.xrootd.plugins.InvalidHandlerConfigurationException;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.EndSessionRequest;
import org.dcache.xrootd.protocol.messages.ErrorResponse;
import org.dcache.xrootd.protocol.messages.LoginRequest;
import org.dcache.xrootd.protocol.messages.LoginResponse;
import org.dcache.xrootd.protocol.messages.OkResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdAuthenticationHandler
extends SimpleChannelUpstreamHandler {
    private static final Logger _log = LoggerFactory.getLogger(XrootdAuthenticationHandler.class);
    private static final ImmutableSet<Integer> WITHOUT_LOGIN = ImmutableSet.of((Object)3024, (Object)3007, (Object)3006);
    private static final ImmutableSet<Integer> WITHOUT_AUTH = ImmutableSet.of((Object)3000, (Object)3024, (Object)3007, (Object)3011, (Object)3006);
    private static final ConcurrentMap<XrootdSessionIdentifier, XrootdSession> _sessions = Maps.newConcurrentMap();
    private final XrootdSessionIdentifier _sessionId = new XrootdSessionIdentifier();
    private final AuthenticationFactory _authenticationFactory;
    private AuthenticationHandler _authenticationHandler;
    private State _state = State.NO_LOGIN;
    private XrootdSession _session;

    public XrootdAuthenticationHandler(AuthenticationFactory authenticationFactory) {
        this._authenticationFactory = authenticationFactory;
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        _sessions.remove(this._sessionId);
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent event) {
        Object msg = event.getMessage();
        if (!(msg instanceof XrootdRequest)) {
            ctx.sendUpstream((ChannelEvent)event);
            return;
        }
        XrootdRequest request = (XrootdRequest)msg;
        int reqId = request.getRequestId();
        try {
            if (this._state == State.NO_LOGIN && !WITHOUT_LOGIN.contains((Object)reqId)) {
                throw new XrootdException(3010, "Login required");
            }
            if (this._state == State.NO_AUTH && !WITHOUT_AUTH.contains((Object)reqId)) {
                throw new XrootdException(3010, "Authentication required");
            }
            switch (reqId) {
                case 3007: {
                    this.doOnLogin(ctx, event, (LoginRequest)request);
                    break;
                }
                case 3000: {
                    this.doOnAuthentication(ctx, event, (AuthenticationRequest)request);
                    break;
                }
                case 3023: {
                    this.doOnEndSession(ctx, event, (EndSessionRequest)request);
                    break;
                }
                default: {
                    request.setSession(this._session);
                    ctx.sendUpstream((ChannelEvent)event);
                    break;
                }
            }
        }
        catch (XrootdException e) {
            ErrorResponse error = new ErrorResponse(request, e.getError(), Strings.nullToEmpty((String)e.getMessage()));
            event.getChannel().write((Object)error);
        }
        catch (RuntimeException e) {
            _log.error("xrootd server error while processing " + msg + " (please report this to support@dcache.org)", (Throwable)e);
            ErrorResponse error = new ErrorResponse(request, 3012, String.format("Internal server error (%s)", e.getMessage()));
            event.getChannel().write((Object)error);
        }
    }

    private void doOnLogin(ChannelHandlerContext context, MessageEvent event, LoginRequest request) throws XrootdException {
        try {
            this._state = State.NO_LOGIN;
            this._session = new XrootdSession(this._sessionId, context.getChannel(), request);
            this._authenticationHandler = this._authenticationFactory.createHandler();
            LoginResponse response = new LoginResponse((XrootdRequest)request, this._sessionId, this._authenticationHandler.getProtocol());
            if (this._authenticationHandler.isCompleted()) {
                this.authenticated(context, this._authenticationHandler.getSubject());
            } else {
                this._state = State.NO_AUTH;
            }
            event.getChannel().write((Object)response);
            _sessions.put(this._sessionId, this._session);
        }
        catch (InvalidHandlerConfigurationException e) {
            _log.error("Could not instantiate authentication handler: {}", (Throwable)e);
            throw new XrootdException(3012, "Internal server error");
        }
    }

    private void doOnAuthentication(ChannelHandlerContext context, MessageEvent event, AuthenticationRequest request) throws XrootdException {
        AbstractResponseMessage response = this._authenticationHandler.authenticate(request);
        if (this._authenticationHandler.isCompleted()) {
            this._state = State.NO_LOGIN;
            this.authenticated(context, this._authenticationHandler.getSubject());
        }
        event.getChannel().write((Object)response);
    }

    private void doOnEndSession(ChannelHandlerContext ctx, MessageEvent event, EndSessionRequest request) throws XrootdException {
        XrootdSession session = (XrootdSession)_sessions.get(request.getSessionId());
        if (session == null) {
            throw new XrootdException(3011, "session not found");
        }
        if (!session.hasOwner(this._session.getSubject())) {
            throw new XrootdException(3010, "not session owner");
        }
        session.getChannel().close();
        event.getChannel().write((Object)new OkResponse(request));
    }

    private void authenticated(ChannelHandlerContext context, Subject subject) throws XrootdException {
        this._session.setSubject(this.login(context, subject));
        this._state = State.AUTH;
        this._authenticationHandler = null;
    }

    protected Subject login(ChannelHandlerContext context, Subject subject) throws XrootdException {
        return subject;
    }

    private static enum State {
        NO_LOGIN,
        NO_AUTH,
        AUTH;

    }
}

