/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.core.XrootdRequestHandler;
import org.dcache.xrootd.plugins.AuthorizationFactory;
import org.dcache.xrootd.plugins.AuthorizationHandler;
import org.dcache.xrootd.protocol.XrootdProtocol;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.CloseRequest;
import org.dcache.xrootd.protocol.messages.DirListRequest;
import org.dcache.xrootd.protocol.messages.LocateRequest;
import org.dcache.xrootd.protocol.messages.MkDirRequest;
import org.dcache.xrootd.protocol.messages.MvRequest;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.protocol.messages.PathRequest;
import org.dcache.xrootd.protocol.messages.PrepareRequest;
import org.dcache.xrootd.protocol.messages.ProtocolRequest;
import org.dcache.xrootd.protocol.messages.QueryRequest;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.protocol.messages.RmDirRequest;
import org.dcache.xrootd.protocol.messages.RmRequest;
import org.dcache.xrootd.protocol.messages.SetRequest;
import org.dcache.xrootd.protocol.messages.StatRequest;
import org.dcache.xrootd.protocol.messages.StatxRequest;
import org.dcache.xrootd.protocol.messages.SyncRequest;
import org.dcache.xrootd.protocol.messages.WriteRequest;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.util.OpaqueStringParser;
import org.dcache.xrootd.util.ParseException;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelEvent;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.MessageEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class XrootdAuthorizationHandler
extends XrootdRequestHandler {
    private static final Logger _log = LoggerFactory.getLogger(XrootdAuthorizationHandler.class);
    private final AuthorizationFactory _authorizationFactory;

    public XrootdAuthorizationHandler(AuthorizationFactory authorizationFactory) {
        this._authorizationFactory = authorizationFactory;
    }

    @Override
    protected AbstractResponseMessage doOnStat(ChannelHandlerContext ctx, MessageEvent event, StatRequest req) throws XrootdException {
        this.authorize(event, req, XrootdProtocol.FilePerm.READ);
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected AbstractResponseMessage doOnStatx(ChannelHandlerContext ctx, MessageEvent event, StatxRequest req) throws XrootdException {
        if (req.getPaths().length == 0) {
            throw new XrootdException(3001, "no paths specified");
        }
        String[] paths = req.getPaths();
        String[] opaques = req.getOpaques();
        int[] flags = new int[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = this.authorize(event, req, XrootdProtocol.FilePerm.READ, paths[i], opaques[i]);
        }
        req.setPaths(paths);
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected AbstractResponseMessage doOnRm(ChannelHandlerContext ctx, MessageEvent event, RmRequest req) throws XrootdException {
        if (req.getPath().isEmpty()) {
            throw new XrootdException(3001, "no path specified");
        }
        this.authorize(event, req, XrootdProtocol.FilePerm.DELETE);
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected AbstractResponseMessage doOnRmDir(ChannelHandlerContext ctx, MessageEvent event, RmDirRequest req) throws XrootdException {
        if (req.getPath().isEmpty()) {
            throw new XrootdException(3001, "no path specified");
        }
        this.authorize(event, req, XrootdProtocol.FilePerm.DELETE);
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected AbstractResponseMessage doOnMkDir(ChannelHandlerContext ctx, MessageEvent event, MkDirRequest req) throws XrootdException {
        if (req.getPath().isEmpty()) {
            throw new XrootdException(3001, "no path specified");
        }
        this.authorize(event, req, XrootdProtocol.FilePerm.WRITE);
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected AbstractResponseMessage doOnMv(ChannelHandlerContext ctx, MessageEvent event, MvRequest req) throws XrootdException {
        String sourcePath = req.getSourcePath();
        if (sourcePath.isEmpty()) {
            throw new XrootdException(3001, "No source path specified");
        }
        String targetPath = req.getTargetPath();
        if (targetPath.isEmpty()) {
            throw new XrootdException(3001, "No target path specified");
        }
        req.setSourcePath(this.authorize(event, req, XrootdProtocol.FilePerm.DELETE, req.getSourcePath(), req.getOpaque()));
        req.setTargetPath(this.authorize(event, req, XrootdProtocol.FilePerm.WRITE, req.getTargetPath(), req.getOpaque()));
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected AbstractResponseMessage doOnDirList(ChannelHandlerContext ctx, MessageEvent event, DirListRequest request) throws XrootdException {
        Channel channel = event.getChannel();
        InetSocketAddress localAddress = (InetSocketAddress)channel.getLocalAddress();
        String path = request.getPath();
        if (path.isEmpty()) {
            throw new XrootdException(3001, "no source path specified");
        }
        this.authorize(event, request, XrootdProtocol.FilePerm.READ);
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected AbstractResponseMessage doOnPrepare(ChannelHandlerContext ctx, MessageEvent event, PrepareRequest msg) {
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected Void doOnLocate(ChannelHandlerContext ctx, MessageEvent event, LocateRequest msg) throws XrootdException {
        String path = msg.getPath();
        if (!path.startsWith("*")) {
            path = this.authorize(event, msg, XrootdProtocol.FilePerm.READ, path, msg.getOpaque());
        } else if (!path.equals("*")) {
            path = this.authorize(event, msg, XrootdProtocol.FilePerm.READ, path.substring(1), msg.getOpaque());
        }
        msg.setPath(path);
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected AbstractResponseMessage doOnOpen(ChannelHandlerContext ctx, MessageEvent event, OpenRequest msg) throws XrootdException {
        XrootdProtocol.FilePerm neededPerm = msg.isNew() || msg.isReadWrite() ? XrootdProtocol.FilePerm.WRITE : XrootdProtocol.FilePerm.READ;
        this.authorize(event, msg, neededPerm);
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected AbstractResponseMessage doOnRead(ChannelHandlerContext ctx, MessageEvent event, ReadRequest msg) throws XrootdException {
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected AbstractResponseMessage doOnReadV(ChannelHandlerContext ctx, MessageEvent event, ReadVRequest msg) throws XrootdException {
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected AbstractResponseMessage doOnWrite(ChannelHandlerContext ctx, MessageEvent event, WriteRequest msg) throws XrootdException {
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected AbstractResponseMessage doOnSync(ChannelHandlerContext ctx, MessageEvent event, SyncRequest msg) throws XrootdException {
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected AbstractResponseMessage doOnClose(ChannelHandlerContext ctx, MessageEvent event, CloseRequest msg) throws XrootdException {
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected AbstractResponseMessage doOnProtocolRequest(ChannelHandlerContext ctx, MessageEvent event, ProtocolRequest msg) throws XrootdException {
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected Object doOnQuery(ChannelHandlerContext ctx, MessageEvent event, QueryRequest req) throws XrootdException {
        switch (req.getReqcode()) {
            case 3: 
            case 4: {
                String opaque;
                String path;
                String args = req.getArgs();
                int pos = args.indexOf(63);
                if (pos > -1) {
                    path = args.substring(0, pos);
                    opaque = args.substring(pos + 1);
                } else {
                    path = args;
                    opaque = "";
                }
                req.setArgs(this.authorize(event, req, XrootdProtocol.FilePerm.READ, path, opaque));
            }
        }
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    @Override
    protected Object doOnSet(ChannelHandlerContext ctx, MessageEvent event, SetRequest request) throws XrootdException {
        ctx.sendUpstream((ChannelEvent)event);
        return null;
    }

    private void authorize(MessageEvent event, PathRequest request, XrootdProtocol.FilePerm neededPerm) throws XrootdException {
        request.setPath(this.authorize(event, request, neededPerm, request.getPath(), request.getOpaque()));
    }

    private String authorize(MessageEvent event, XrootdRequest request, XrootdProtocol.FilePerm neededPerm, String path, String opaque) throws XrootdException {
        try {
            Channel channel = event.getChannel();
            InetSocketAddress localAddress = (InetSocketAddress)channel.getLocalAddress();
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.getRemoteAddress();
            AuthorizationHandler handler = this._authorizationFactory.createHandler();
            return handler.authorize(request.getSubject(), localAddress, remoteAddress, path, OpaqueStringParser.getOpaqueMap(opaque), request.getRequestId(), neededPerm);
        }
        catch (GeneralSecurityException e) {
            throw new XrootdException(3012, "Authorization check failed: " + e.getMessage());
        }
        catch (SecurityException e) {
            throw new XrootdException(3010, "Permission denied: " + e.getMessage());
        }
        catch (ParseException e) {
            throw new XrootdException(3010, "Invalid opaque data: " + e.getMessage() + " (opaque=" + opaque + ")");
        }
    }
}

