/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.CloseRequest;
import org.dcache.xrootd.protocol.messages.DirListRequest;
import org.dcache.xrootd.protocol.messages.EndSessionRequest;
import org.dcache.xrootd.protocol.messages.HandshakeRequest;
import org.dcache.xrootd.protocol.messages.LocateRequest;
import org.dcache.xrootd.protocol.messages.LoginRequest;
import org.dcache.xrootd.protocol.messages.MkDirRequest;
import org.dcache.xrootd.protocol.messages.MvRequest;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.protocol.messages.PrepareRequest;
import org.dcache.xrootd.protocol.messages.ProtocolRequest;
import org.dcache.xrootd.protocol.messages.QueryRequest;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.protocol.messages.RmDirRequest;
import org.dcache.xrootd.protocol.messages.RmRequest;
import org.dcache.xrootd.protocol.messages.SetRequest;
import org.dcache.xrootd.protocol.messages.StatRequest;
import org.dcache.xrootd.protocol.messages.StatxRequest;
import org.dcache.xrootd.protocol.messages.SyncRequest;
import org.dcache.xrootd.protocol.messages.UnknownRequest;
import org.dcache.xrootd.protocol.messages.WriteRequest;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.FrameDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdDecoder
extends FrameDecoder {
    private static final Logger _logger = LoggerFactory.getLogger(XrootdDecoder.class);
    private boolean gotHandshake = false;

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) {
        int readable = buffer.readableBytes();
        if (!this.gotHandshake) {
            if (readable < 20) {
                return null;
            }
            this.gotHandshake = true;
            return new HandshakeRequest(buffer.readSlice(20));
        }
        if (readable < 24) {
            return null;
        }
        int pos = buffer.readerIndex();
        int headerFrameLength = buffer.getInt(pos + 20);
        if (headerFrameLength < 0) {
            _logger.error("Received illegal frame length in xrootd header: {}. Closing channel.", (Object)headerFrameLength);
            channel.close();
            return null;
        }
        int length = 24 + headerFrameLength;
        if (readable < length) {
            return null;
        }
        ChannelBuffer frame = buffer.readBytes(length);
        int requestID = frame.getUnsignedShort(2);
        switch (requestID) {
            case 3007: {
                return new LoginRequest(frame);
            }
            case 3021: {
                return new PrepareRequest(frame);
            }
            case 3010: {
                return new OpenRequest(frame);
            }
            case 3017: {
                return new StatRequest(frame);
            }
            case 3022: {
                return new StatxRequest(frame);
            }
            case 3013: {
                return new ReadRequest(frame);
            }
            case 3025: {
                return new ReadVRequest(frame);
            }
            case 3019: {
                return new WriteRequest(frame);
            }
            case 3016: {
                return new SyncRequest(frame);
            }
            case 3003: {
                return new CloseRequest(frame);
            }
            case 3006: {
                return new ProtocolRequest(frame);
            }
            case 3014: {
                return new RmRequest(frame);
            }
            case 3015: {
                return new RmDirRequest(frame);
            }
            case 3008: {
                return new MkDirRequest(frame);
            }
            case 3009: {
                return new MvRequest(frame);
            }
            case 3004: {
                return new DirListRequest(frame);
            }
            case 3000: {
                return new AuthenticationRequest(frame);
            }
            case 3023: {
                return new EndSessionRequest(frame);
            }
            case 3027: {
                return new LocateRequest(frame);
            }
            case 3001: {
                return new QueryRequest(frame);
            }
            case 3018: {
                return new SetRequest(frame);
            }
        }
        return new UnknownRequest(frame);
    }
}

