/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import javax.security.auth.Subject;
import org.dcache.xrootd.core.XrootdSessionIdentifier;
import org.dcache.xrootd.protocol.messages.LoginRequest;
import org.jboss.netty.channel.Channel;

public class XrootdSession {
    private final Channel _channel;
    private final XrootdSessionIdentifier _id;
    private final LoginRequest _loginRequest;
    private Subject _subject;

    public XrootdSession(XrootdSessionIdentifier id, Channel channel, LoginRequest loginRequest) {
        this._id = id;
        this._channel = channel;
        this._loginRequest = loginRequest;
    }

    public boolean hasOwner(Subject subject) {
        if (this._subject == null) {
            return subject == null;
        }
        return this._subject.getPrincipals().equals(subject.getPrincipals());
    }

    public void setSubject(Subject subject) {
        this._subject = subject;
    }

    public Subject getSubject() {
        return this._subject;
    }

    public Channel getChannel() {
        return this._channel;
    }

    public XrootdSessionIdentifier getSessionIdentifier() {
        return this._id;
    }

    public String getToken() {
        return this._loginRequest.getToken();
    }

    public String getUserName() {
        return this._loginRequest.getUserName();
    }

    public int getClientProtocolVersion() {
        return this._loginRequest.getClientProtocolVersion();
    }

    public boolean isAdmin() {
        return this._loginRequest.isAdmin();
    }

    public int getPID() {
        return this._loginRequest.getPID();
    }

    public boolean supportsAsyn() {
        return this._loginRequest.supportsAsyn();
    }
}

