/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import com.google.common.base.Preconditions;
import java.security.SecureRandom;
import java.util.Arrays;

public class XrootdSessionIdentifier {
    private static final SecureRandom _random = new SecureRandom();
    private final byte[] _sessionId;

    public XrootdSessionIdentifier() {
        this._sessionId = new byte[16];
        _random.nextBytes(this._sessionId);
    }

    public XrootdSessionIdentifier(byte[] sessionId) {
        Preconditions.checkArgument((sessionId.length == 16 ? 1 : 0) != 0);
        this._sessionId = sessionId;
    }

    public byte[] getBytes() {
        return Arrays.copyOf(this._sessionId, this._sessionId.length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XrootdSessionIdentifier that = (XrootdSessionIdentifier)o;
        return Arrays.equals(this._sessionId, that._sessionId);
    }

    public int hashCode() {
        return Arrays.hashCode(this._sessionId);
    }
}

