/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import java.io.UnsupportedEncodingException;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public abstract class AbstractResponseMessage {
    protected final XrootdRequest _request;
    protected ChannelBuffer _buffer;

    public AbstractResponseMessage(XrootdRequest request, int stat, int length) {
        this._request = request;
        this._buffer = ChannelBuffers.dynamicBuffer((int)(8 + length));
        this.putUnsignedShort(request.getStreamId());
        this.putUnsignedShort(stat);
        this.putSignedInt(0);
    }

    public final void setStatus(int s) {
        this._buffer.setByte(2, (int)((byte)(s >> 8)));
        this._buffer.setByte(3, (int)((byte)s));
    }

    protected final void put(byte[] field) {
        this._buffer.writeBytes(field);
    }

    protected final void putUnsignedChar(int c) {
        this._buffer.writeByte((int)((byte)c));
    }

    protected final void putUnsignedShort(int s) {
        this._buffer.writeByte((int)((byte)(s >> 8)));
        this._buffer.writeByte((int)((byte)s));
    }

    protected final void putSignedInt(int i) {
        this._buffer.writeInt(i);
    }

    protected final void putSignedLong(long l) {
        this._buffer.writeLong(l);
    }

    protected final void putCharSequence(String s) {
        try {
            this.put(s.getBytes("ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Failed to construct xrootd message", e);
        }
    }

    public ChannelBuffer getBuffer() {
        return this._buffer;
    }

    public XrootdRequest getRequest() {
        return this._request;
    }
}

