/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.Joiner;
import java.net.InetSocketAddress;
import org.dcache.xrootd.protocol.messages.AbstractResponseMessage;
import org.dcache.xrootd.protocol.messages.XrootdRequest;

public class LocateResponse
extends AbstractResponseMessage {
    private final String encoded;

    public LocateResponse(XrootdRequest request, InfoElement ... info) {
        this(request, LocateResponse.encode(info));
    }

    private LocateResponse(XrootdRequest request, String encoded) {
        super(request, 0, encoded.length());
        this.encoded = encoded;
        this.putCharSequence(encoded);
    }

    public static String encode(InfoElement[] info) {
        return Joiner.on((String)" ").join((Object[])info);
    }

    public String toString() {
        return "locate-reponse[" + this.encoded + "]";
    }

    public static class InfoElement {
        private final InetSocketAddress address;
        private final Node node;
        private final Access access;

        public InfoElement(InetSocketAddress address, Node node, Access access) {
            this.address = address;
            this.node = node;
            this.access = access;
        }

        public String toString() {
            return this.node.value + this.access.value + "[::" + this.address.getAddress().getHostAddress() + "]:" + this.address.getPort();
        }
    }

    public static enum Access {
        READ("r"),
        WRITE("w");

        final String value;

        private Access(String value) {
            this.value = value;
        }
    }

    public static enum Node {
        MANAGER("M"),
        MANAGER_PENDING("m"),
        SERVER("S"),
        SERVER_PENDING("s");

        final String value;

        private Node(String value) {
            this.value = value;
        }
    }
}

