/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.CharMatcher;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.jboss.netty.buffer.ChannelBuffer;

public class QueryRequest
extends XrootdRequest {
    public static final CharMatcher NULL_CHARACTER = CharMatcher.is((char)'\u0000');
    private final int reqcode;
    private final int fhandle;
    private String args;

    public QueryRequest(ChannelBuffer buffer) {
        super(buffer, 3001);
        this.reqcode = buffer.getUnsignedShort(4);
        this.fhandle = buffer.getInt(8);
        int alen = buffer.getInt(20);
        this.args = NULL_CHARACTER.trimTrailingFrom((CharSequence)buffer.toString(24, alen, XROOTD_CHARSET));
    }

    public int getReqcode() {
        return this.reqcode;
    }

    public int getFhandle() {
        return this.fhandle;
    }

    public String getArgs() {
        return this.args;
    }

    public void setArgs(String args) {
        this.args = args;
    }

    public String toString() {
        return String.format("query[%d,%d,%s]", this.reqcode, this.fhandle, this.args);
    }
}

