/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.security;

import org.dcache.xrootd.security.XrootdBucket;
import org.dcache.xrootd.security.XrootdSecurityProtocol;
import org.jboss.netty.buffer.ChannelBuffer;

public class RawBucket
extends XrootdBucket {
    private final byte[] _data;

    public RawBucket(XrootdSecurityProtocol.BucketType type, byte[] data) {
        super(type);
        this._data = data;
    }

    public byte[] getContent() {
        return this._data;
    }

    public static RawBucket deserialize(XrootdSecurityProtocol.BucketType type, ChannelBuffer buffer) {
        byte[] tmp = new byte[buffer.readableBytes()];
        buffer.getBytes(0, tmp);
        return new RawBucket(type, tmp);
    }

    @Override
    public void serialize(ChannelBuffer out) {
        super.serialize(out);
        out.writeInt(this._data.length);
        out.writeBytes(this._data);
    }

    @Override
    public int getSize() {
        return super.getSize() + 4 + this._data.length;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString() + " hex dump:");
        for (byte b : this._data) {
            sb.append(" ").append(Integer.toHexString(b));
        }
        return sb.toString();
    }
}

