/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.stream;

import java.io.IOException;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.ReadResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.stream.ChunkedResponse;
import org.jboss.netty.buffer.ChannelBuffer;

public abstract class AbstractChunkedReadResponse
implements ChunkedResponse {
    protected final ReadRequest request;
    protected final int maxFrameSize;
    protected long position;
    protected int length;
    protected boolean isEndOfInput;

    public AbstractChunkedReadResponse(ReadRequest request, int maxFrameSize) {
        this.request = request;
        this.maxFrameSize = maxFrameSize;
        this.position = request.getReadOffset();
        this.length = request.bytesToRead();
    }

    @Override
    public XrootdRequest getRequest() {
        return this.request;
    }

    @Override
    public ReadResponse nextChunk() throws Exception {
        if (this.isEndOfInput) {
            return null;
        }
        ReadResponse response = new ReadResponse(this.request, 0);
        response.append(this.readNext());
        response.setIncomplete(!this.isEndOfInput);
        return response;
    }

    private ChannelBuffer readNext() throws IOException {
        int chunkLength = Math.min(this.length, this.maxFrameSize);
        ChannelBuffer buffer = this.read(this.position, chunkLength);
        int readableBytes = buffer.readableBytes();
        this.position += (long)readableBytes;
        int n = this.length = readableBytes < chunkLength ? 0 : this.length - readableBytes;
        if (this.length == 0) {
            this.isEndOfInput = true;
        }
        return buffer;
    }

    protected abstract ChannelBuffer read(long var1, int var3) throws IOException;

    @Override
    public boolean isEndOfInput() throws Exception {
        return this.isEndOfInput;
    }

    @Override
    public void close() throws Exception {
    }
}

