/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.stream;

import java.io.IOException;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.protocol.messages.GenericReadRequestMessage;
import org.dcache.xrootd.protocol.messages.ReadResponse;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.stream.ChunkedResponse;
import org.jboss.netty.buffer.ChannelBuffer;

public abstract class AbstractChunkedReadvResponse
implements ChunkedResponse {
    protected final ReadVRequest request;
    protected final int maxFrameSize;
    protected final GenericReadRequestMessage.EmbeddedReadRequest[] requests;
    protected int index;

    public AbstractChunkedReadvResponse(ReadVRequest request, int maxFrameSize) {
        this.maxFrameSize = maxFrameSize;
        this.request = request;
        this.requests = request.getReadRequestList();
    }

    @Override
    public XrootdRequest getRequest() {
        return this.request;
    }

    @Override
    public ReadResponse nextChunk() throws Exception {
        if (this.isEndOfInput()) {
            return null;
        }
        int count = this.getChunksInNextFrame(this.maxFrameSize);
        ChannelBuffer[] chunks = new ChannelBuffer[this.requests.length];
        for (int i = this.index; i < this.index + count; ++i) {
            chunks[i] = this.read(this.requests[i]);
        }
        ReadResponse response = new ReadResponse(this.request, 0);
        response.write(this.requests, chunks, this.index, count);
        response.setIncomplete(this.index + count < this.requests.length);
        this.index += count;
        return response;
    }

    @Override
    public boolean isEndOfInput() throws Exception {
        return this.index == this.requests.length;
    }

    @Override
    public void close() throws Exception {
    }

    private int getLengthOfRequest(GenericReadRequestMessage.EmbeddedReadRequest request) throws IOException, XrootdException {
        return (int)Math.min((long)request.BytesToRead(), this.getSize(request.getFileHandle()) - request.getOffset());
    }

    private int getChunksInNextFrame(int maxFrameSize) throws IOException, XrootdException {
        long length = 0L;
        int count = 0;
        for (int i = this.index; i < this.requests.length && length < (long)maxFrameSize; ++i) {
            length += 16L;
            length += (long)this.getLengthOfRequest(this.requests[i]);
            ++count;
        }
        if (length > (long)maxFrameSize) {
            --count;
        }
        if (count == 0) {
            throw new IllegalStateException("Maximum chunk size exceeded");
        }
        return count;
    }

    private ChannelBuffer read(GenericReadRequestMessage.EmbeddedReadRequest request) throws IOException, XrootdException {
        return this.read(request.getFileHandle(), request.getOffset(), request.BytesToRead());
    }

    protected abstract long getSize(int var1) throws IOException, XrootdException;

    protected abstract ChannelBuffer read(int var1, long var2, int var4) throws IOException, XrootdException;
}

