/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.stream.AbstractChunkedReadResponse;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;

public class ChunkedFileChannelReadResponse
extends AbstractChunkedReadResponse {
    private final FileChannel channel;

    public ChunkedFileChannelReadResponse(ReadRequest request, int maxFrameSize, FileChannel channel) {
        super(request, maxFrameSize);
        this.channel = channel;
    }

    @Override
    protected ChannelBuffer read(long position, int length) throws IOException {
        int bytes;
        ByteBuffer chunk = ByteBuffer.allocate(length);
        while (length > 0 && (bytes = this.channel.read(chunk, position)) >= 0) {
            position += (long)bytes;
            length -= bytes;
        }
        chunk.flip();
        return ChannelBuffers.wrappedBuffer((ByteBuffer)chunk);
    }
}

