/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.protocol.messages.AbstractXrootdResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorResponse<T extends XrootdRequest>
extends AbstractXrootdResponse<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ErrorResponse.class);
    private final int errnum;
    private final String errmsg;

    public ErrorResponse(T request, int errnum, String errmsg) {
        super(request, 4003);
        this.errnum = errnum;
        this.errmsg = errmsg;
        LOGGER.info("Xrootd-Error-Response: ErrorNr={} ErrorMsg={}", (Object)errnum, (Object)errmsg);
    }

    public int getErrorNumber() {
        return this.errnum;
    }

    public String getErrorMessage() {
        return this.errmsg;
    }

    @Override
    protected int getLength() {
        return super.getLength() + 4 + this.errmsg.length() + 1;
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        super.getBytes(buffer);
        buffer.writeInt(this.errnum);
        buffer.writeBytes(this.errmsg.getBytes(StandardCharsets.US_ASCII));
        buffer.writeByte(0);
    }

    public String toString() {
        return String.format("error[%d,%s]", this.errnum, this.errmsg);
    }
}

