/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.AbstractReferenceCounted;
import java.util.ArrayList;
import java.util.List;
import org.dcache.xrootd.protocol.messages.GenericReadRequestMessage;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;

public class ReadVResponse
extends AbstractReferenceCounted
implements XrootdResponse<ReadVRequest> {
    public static final int READ_LIST_HEADER_SIZE = 16;
    private final ReadVRequest request;
    private final int stat;
    private final GenericReadRequestMessage.EmbeddedReadRequest[] requests;
    private final ByteBuf[] data;
    private final int index;
    private final int length;

    public ReadVResponse(ReadVRequest request, GenericReadRequestMessage.EmbeddedReadRequest[] requests, ByteBuf[] data, int index, int length, boolean isIncomplete) {
        Preconditions.checkArgument((length > 0 ? 1 : 0) != 0);
        this.request = (ReadVRequest)Preconditions.checkNotNull((Object)request);
        this.stat = isIncomplete ? 4000 : 0;
        this.requests = (GenericReadRequestMessage.EmbeddedReadRequest[])Preconditions.checkNotNull((Object)requests);
        this.data = (ByteBuf[])Preconditions.checkNotNull((Object)data);
        this.index = index;
        this.length = length;
    }

    @Override
    public ReadVRequest getRequest() {
        return this.request;
    }

    @Override
    public int getStatus() {
        return this.stat;
    }

    public List<ByteBuf> getSegments() {
        ArrayList<ByteBuf> chunks = new ArrayList<ByteBuf>(this.length);
        for (int i = 0; i < this.length; ++i) {
            chunks.add(Unpooled.unmodifiableBuffer((ByteBuf)this.data[this.index + i]));
        }
        return chunks;
    }

    public List<Integer> getSegmentLengths() {
        ArrayList<Integer> chunks = new ArrayList<Integer>(this.length);
        for (int i = 0; i < this.length; ++i) {
            chunks.add(this.data[this.index + i].readableBytes());
        }
        return chunks;
    }

    public int getIndex() {
        return this.index;
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public void writeTo(ChannelHandlerContext ctx, ChannelPromise promise) {
        Preconditions.checkState((this.refCnt() > 0 ? 1 : 0) != 0);
        int payload = 0;
        for (int i = 0; i < this.length; ++i) {
            payload += 16;
            payload += this.data[this.index + i].readableBytes();
        }
        CompositeByteBuf buffer = ctx.alloc().compositeBuffer(2 * this.length + 1);
        ByteBuf header = ctx.alloc().buffer(8);
        header.writeShort(this.request.getStreamId());
        header.writeShort(this.stat);
        header.writeInt(payload);
        buffer.addComponent(header);
        for (int i = 0; i < this.length; ++i) {
            header = ctx.alloc().buffer(16);
            header.writeInt(this.requests[this.index + i].getFileHandle());
            header.writeInt(this.data[this.index + i].readableBytes());
            header.writeLong(this.requests[this.index + i].getOffset());
            buffer.addComponent(header);
            buffer.addComponent(this.data[this.index + i].retain());
        }
        buffer.writerIndex(buffer.capacity());
        ctx.write((Object)buffer, promise);
        this.release();
    }

    public String toString() {
        int payload = 0;
        for (int i = 0; i < this.length; ++i) {
            payload += this.data[this.index + i].readableBytes();
        }
        return String.format("readv-response[elements=%d,bytes=%d]", this.length, payload);
    }

    protected void deallocate() {
        for (int i = 0; i < this.length; ++i) {
            this.data[i + this.index].release();
        }
    }
}

