/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.protocol.messages.AbstractXrootdResponse;
import org.dcache.xrootd.protocol.messages.StatRequest;
import org.dcache.xrootd.util.FileStatus;

public class StatResponse
extends AbstractXrootdResponse<StatRequest> {
    private final FileStatus fs;
    private final String info;

    public StatResponse(StatRequest request, FileStatus fs) {
        this(request, fs, fs.toString());
    }

    private StatResponse(StatRequest request, FileStatus fs, String info) {
        super(request, 0);
        this.fs = fs;
        this.info = info;
    }

    public long getSize() {
        return this.fs.getSize();
    }

    public int getFlags() {
        return this.fs.getFlags();
    }

    public long getId() {
        return this.fs.getId();
    }

    public long getModificationTime() {
        return this.fs.getModificationTime();
    }

    @Override
    protected int getLength() {
        return super.getLength() + this.info.length() + 1;
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        super.getBytes(buffer);
        buffer.writeBytes(this.info.getBytes(StandardCharsets.US_ASCII));
        buffer.writeByte(0);
    }

    public String toString() {
        return String.format("stat-response[%s]", this.fs);
    }
}

