/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.protocol.messages;

import com.google.common.base.CaseFormat;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.dcache.xrootd.protocol.messages.AbstractXrootdResponse;
import org.dcache.xrootd.protocol.messages.XrootdRequest;

public class StringResponse<T extends XrootdRequest>
extends AbstractXrootdResponse<T> {
    protected final String response;

    public StringResponse(T request, int stat, String response) {
        super(request, stat);
        this.response = response;
    }

    public String getResponse() {
        return this.response;
    }

    @Override
    protected int getLength() {
        return super.getLength() + this.response.length();
    }

    @Override
    protected void getBytes(ByteBuf buffer) {
        super.getBytes(buffer);
        buffer.writeBytes(this.response.getBytes(StandardCharsets.US_ASCII));
    }

    public String toString() {
        String type = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_HYPHEN, this.getClass().getSimpleName());
        return String.format("%s[%s]", type, this.response);
    }
}

