/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.stream.AbstractChunkedReadResponse;

public class ChunkedFileChannelReadResponse
extends AbstractChunkedReadResponse {
    private final FileChannel channel;

    public ChunkedFileChannelReadResponse(ReadRequest request, int maxFrameSize, FileChannel channel) {
        super(request, maxFrameSize);
        this.channel = channel;
    }

    @Override
    protected ByteBuf read(ByteBufAllocator alloc, long position, int length) throws IOException {
        int bytes;
        ByteBuf chunk = alloc.ioBuffer(length);
        chunk.writerIndex(length);
        ByteBuffer buffer = chunk.nioBuffer();
        while (length > 0 && (bytes = this.channel.read(buffer, position)) >= 0) {
            position += (long)bytes;
            length -= bytes;
        }
        chunk.writerIndex(chunk.writerIndex() - length);
        return chunk;
    }
}

