/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.List;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.stream.AbstractChunkedReadvResponse;

public class ChunkedFileChannelReadvResponse
extends AbstractChunkedReadvResponse {
    private final List<FileChannel> channels;

    public ChunkedFileChannelReadvResponse(ReadVRequest request, int maxFrameSize, List<FileChannel> channels) {
        super(request, maxFrameSize);
        this.channels = channels;
    }

    private void checkValidFileDescriptor(int fd) throws XrootdException {
        if (fd < 0 || fd >= this.channels.size() || this.channels.get(fd) == null) {
            throw new XrootdException(3004, "Invalid file descriptor");
        }
    }

    @Override
    protected long getSize(int fd) throws IOException, XrootdException {
        this.checkValidFileDescriptor(fd);
        return this.channels.get(fd).size();
    }

    @Override
    protected ByteBuf read(ByteBufAllocator alloc, int fd, long position, int length) throws IOException, XrootdException {
        int bytes;
        this.checkValidFileDescriptor(fd);
        FileChannel channel = this.channels.get(fd);
        ByteBuf chunk = alloc.ioBuffer(length);
        chunk.writerIndex(length);
        ByteBuffer buffer = chunk.nioBuffer();
        while (length > 0 && (bytes = channel.read(buffer, position)) >= 0) {
            position += (long)bytes;
            length -= bytes;
        }
        chunk.writerIndex(chunk.writerIndex() - length);
        return chunk;
    }
}

