/*
 * Decompiled with CFR 0.152.
 */
package org.dcache.xrootd.core;

import com.google.common.base.Strings;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import org.dcache.xrootd.core.XrootdException;
import org.dcache.xrootd.protocol.messages.AuthenticationRequest;
import org.dcache.xrootd.protocol.messages.CloseRequest;
import org.dcache.xrootd.protocol.messages.DirListRequest;
import org.dcache.xrootd.protocol.messages.ErrorResponse;
import org.dcache.xrootd.protocol.messages.LocateRequest;
import org.dcache.xrootd.protocol.messages.LoginRequest;
import org.dcache.xrootd.protocol.messages.MkDirRequest;
import org.dcache.xrootd.protocol.messages.MvRequest;
import org.dcache.xrootd.protocol.messages.OkResponse;
import org.dcache.xrootd.protocol.messages.OpenRequest;
import org.dcache.xrootd.protocol.messages.PrepareRequest;
import org.dcache.xrootd.protocol.messages.ProtocolRequest;
import org.dcache.xrootd.protocol.messages.QueryRequest;
import org.dcache.xrootd.protocol.messages.ReadRequest;
import org.dcache.xrootd.protocol.messages.ReadVRequest;
import org.dcache.xrootd.protocol.messages.RmDirRequest;
import org.dcache.xrootd.protocol.messages.RmRequest;
import org.dcache.xrootd.protocol.messages.SetRequest;
import org.dcache.xrootd.protocol.messages.StatRequest;
import org.dcache.xrootd.protocol.messages.StatxRequest;
import org.dcache.xrootd.protocol.messages.SyncRequest;
import org.dcache.xrootd.protocol.messages.WriteRequest;
import org.dcache.xrootd.protocol.messages.XrootdRequest;
import org.dcache.xrootd.protocol.messages.XrootdResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XrootdRequestHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger _log = LoggerFactory.getLogger(XrootdRequestHandler.class);

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof XrootdRequest) {
            this.requestReceived(ctx, (XrootdRequest)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void requestReceived(ChannelHandlerContext ctx, XrootdRequest req) {
        try {
            Object response;
            switch (req.getRequestId()) {
                case 3000: {
                    response = this.doOnAuthentication(ctx, (AuthenticationRequest)req);
                    break;
                }
                case 3007: {
                    response = this.doOnLogin(ctx, (LoginRequest)req);
                    break;
                }
                case 3010: {
                    response = this.doOnOpen(ctx, (OpenRequest)req);
                    break;
                }
                case 3017: {
                    response = this.doOnStat(ctx, (StatRequest)req);
                    break;
                }
                case 3022: {
                    response = this.doOnStatx(ctx, (StatxRequest)req);
                    break;
                }
                case 3013: {
                    response = this.doOnRead(ctx, (ReadRequest)req);
                    break;
                }
                case 3025: {
                    response = this.doOnReadV(ctx, (ReadVRequest)req);
                    break;
                }
                case 3019: {
                    response = this.doOnWrite(ctx, (WriteRequest)req);
                    break;
                }
                case 3016: {
                    response = this.doOnSync(ctx, (SyncRequest)req);
                    break;
                }
                case 3003: {
                    response = this.doOnClose(ctx, (CloseRequest)req);
                    break;
                }
                case 3006: {
                    response = this.doOnProtocolRequest(ctx, (ProtocolRequest)req);
                    break;
                }
                case 3014: {
                    response = this.doOnRm(ctx, (RmRequest)req);
                    break;
                }
                case 3015: {
                    response = this.doOnRmDir(ctx, (RmDirRequest)req);
                    break;
                }
                case 3008: {
                    response = this.doOnMkDir(ctx, (MkDirRequest)req);
                    break;
                }
                case 3009: {
                    response = this.doOnMv(ctx, (MvRequest)req);
                    break;
                }
                case 3004: {
                    response = this.doOnDirList(ctx, (DirListRequest)req);
                    break;
                }
                case 3021: {
                    response = this.doOnPrepare(ctx, (PrepareRequest)req);
                    break;
                }
                case 3027: {
                    response = this.doOnLocate(ctx, (LocateRequest)req);
                    break;
                }
                case 3001: {
                    response = this.doOnQuery(ctx, (QueryRequest)req);
                    break;
                }
                case 3018: {
                    response = this.doOnSet(ctx, (SetRequest)req);
                    break;
                }
                default: {
                    response = this.unsupported(ctx, req);
                }
            }
            if (response != null) {
                this.respond(ctx, response);
            } else {
                req = null;
            }
        }
        catch (XrootdException e) {
            this.respond(ctx, this.withError(req, e.getError(), e.getMessage()));
        }
        catch (RuntimeException e) {
            _log.error("xrootd server error while processing " + req + " (please report this to support@dcache.org)", (Throwable)e);
            this.respond(ctx, this.withError(req, 3012, String.format("Internal server error (%s)", e.getMessage())));
        }
        finally {
            ReferenceCountUtil.release((Object)req);
        }
    }

    protected <T extends XrootdRequest> OkResponse<T> withOk(T req) {
        return new OkResponse<T>(req);
    }

    protected <T extends XrootdRequest> ErrorResponse<T> withError(T req, int errorCode, String errMsg) {
        return new ErrorResponse<T>(req, errorCode, Strings.nullToEmpty((String)errMsg));
    }

    protected ChannelFuture respond(ChannelHandlerContext ctx, Object response) {
        return ctx.writeAndFlush(response).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    protected <T extends XrootdRequest> XrootdResponse<T> unsupported(ChannelHandlerContext ctx, T msg) throws XrootdException {
        _log.warn("Unsupported request: " + msg);
        throw new XrootdException(3013, "Request " + msg.getRequestId() + " not supported");
    }

    protected Object doOnLogin(ChannelHandlerContext ctx, LoginRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnAuthentication(ChannelHandlerContext ctx, AuthenticationRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnOpen(ChannelHandlerContext ctx, OpenRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnStat(ChannelHandlerContext ctx, StatRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnStatx(ChannelHandlerContext ctx, StatxRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnRead(ChannelHandlerContext ctx, ReadRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnReadV(ChannelHandlerContext ctx, ReadVRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnWrite(ChannelHandlerContext ctx, WriteRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnSync(ChannelHandlerContext ctx, SyncRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnClose(ChannelHandlerContext ctx, CloseRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnProtocolRequest(ChannelHandlerContext ctx, ProtocolRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnRm(ChannelHandlerContext ctx, RmRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnRmDir(ChannelHandlerContext ctx, RmDirRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnMkDir(ChannelHandlerContext ctx, MkDirRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnMv(ChannelHandlerContext ctx, MvRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnDirList(ChannelHandlerContext ctx, DirListRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnPrepare(ChannelHandlerContext ctx, PrepareRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnLocate(ChannelHandlerContext ctx, LocateRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnQuery(ChannelHandlerContext ctx, QueryRequest msg) throws XrootdException {
        return this.unsupported(ctx, msg);
    }

    protected Object doOnSet(ChannelHandlerContext ctx, SetRequest request) throws XrootdException {
        return this.unsupported(ctx, request);
    }
}

